/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.common.blockentities.BlockSwapperT1BE;
import com.direwolf20.justdirethings.common.blocks.baseblocks.BaseMachineBlock;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FerricoreWrench
extends Item {
    public FerricoreWrench() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide() || !player.isShiftKeyDown()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        GlobalPos boundPos = FerricoreWrench.getBoundTo(itemstack);
        if (boundPos == null) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        FerricoreWrench.removeBoundTo(itemstack);
        player.displayClientMessage((Component)Component.translatable((String)"justdirethings.bindremoved"), true);
        player.playNotifySound(SoundEvents.ENDER_EYE_DEATH, SoundSource.PLAYERS, 1.0f, 1.0f);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = player.getItemInHand(context.getHand());
        BlockState state = level.getBlockState(pos);
        if (!player.isShiftKeyDown() && this.specialBlockHandling(level, player, pos, state, itemstack)) {
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide) {
            BlockState rotatedState;
            Block block = state.getBlock();
            if (block instanceof BaseMachineBlock) {
                BaseMachineBlock baseMachineBlock = (BaseMachineBlock)block;
                rotatedState = baseMachineBlock.direRotate(state, (LevelAccessor)level, pos, Rotation.CLOCKWISE_90);
            } else {
                rotatedState = state.rotate((LevelAccessor)level, pos, Rotation.CLOCKWISE_90);
            }
            if (rotatedState.equals(state)) {
                return InteractionResult.PASS;
            }
            level.setBlock(pos, rotatedState, 3);
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_ROTATE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean specialBlockHandling(Level level, Player player, BlockPos blockPos, BlockState blockState, ItemStack itemStack) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BlockSwapperT1BE) {
            BlockSwapperT1BE blockSwapperT1BE = (BlockSwapperT1BE)blockEntity;
            if (level.isClientSide) {
                return false;
            }
            GlobalPos boundPos = FerricoreWrench.getBoundTo(itemStack);
            if (boundPos == null) {
                GlobalPos newBind = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)blockPos);
                FerricoreWrench.setBoundTo(itemStack, newBind);
                player.displayClientMessage((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{Component.translatable((String)newBind.dimension().location().getPath()), "[" + newBind.pos().toShortString() + "]"}), true);
                player.playNotifySound(SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                boolean bound = blockSwapperT1BE.handleConnection(boundPos);
                if (bound) {
                    player.displayClientMessage((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{Component.translatable((String)boundPos.dimension().location().getPath()), "[" + boundPos.pos().toShortString() + "]"}), true);
                    player.playNotifySound(SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"justdirethings.bindremoved"), true);
                    player.playNotifySound(SoundEvents.ENDER_EYE_DEATH, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                FerricoreWrench.removeBoundTo(itemStack);
            }
            return true;
        }
        return false;
    }

    public boolean isFoil(ItemStack pStack) {
        return FerricoreWrench.getBoundTo(pStack) != null;
    }

    public static GlobalPos getBoundTo(ItemStack stack) {
        return (GlobalPos)stack.getOrDefault(JustDireDataComponents.BOUND_GLOBAL_POS, null);
    }

    public static void setBoundTo(ItemStack stack, GlobalPos globalPos) {
        stack.set(JustDireDataComponents.BOUND_GLOBAL_POS, (Object)globalPos);
    }

    public static void removeBoundTo(ItemStack stack) {
        stack.remove(JustDireDataComponents.BOUND_GLOBAL_POS);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Level level = context.level();
        if (level == null) {
            return;
        }
        GlobalPos boundPos = FerricoreWrench.getBoundTo(stack);
        ChatFormatting chatFormatting = ChatFormatting.DARK_PURPLE;
        if (boundPos != null) {
            tooltip.add((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{I18n.get((String)boundPos.dimension().location().getPath(), (Object[])new Object[0]), boundPos.pos().toShortString()}).withStyle(chatFormatting));
        }
    }
}

