/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.capabilities;

import com.direwolf20.justdirethings.common.blockentities.InventoryHolderBE;
import com.direwolf20.justdirethings.util.ItemStackKey;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class InventoryHolderItemHandler
extends ItemStackHandler {
    InventoryHolderBE inventoryHolderBE;
    ItemStackHandler sourceHandler;

    public InventoryHolderItemHandler(InventoryHolderBE inventoryHolderBE, ItemStackHandler sourceHandler) {
        super(sourceHandler.getSlots());
        this.inventoryHolderBE = inventoryHolderBE;
        this.sourceHandler = sourceHandler;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.inventoryHolderBE == null) {
            return ItemStack.EMPTY;
        }
        int amountAllowed = this.inventoryHolderBE.allowedExtractAmount(slot, amount);
        return this.sourceHandler.extractItem(slot, amountAllowed, simulate);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStackKey key = new ItemStackKey(stack, this.inventoryHolderBE.compareNBT);
        if (this.inventoryHolderBE.filteredCache.containsKey(key)) {
            List<Integer> slotsList = this.inventoryHolderBE.filteredCache.get(key);
            if (slotsList.contains(slot)) {
                return this.insertItemProxy(slot, stack, simulate);
            }
            for (Integer i : slotsList) {
                stack = this.insertItemProxy(i, stack, simulate);
            }
        }
        return this.insertItemProxy(slot, stack, simulate);
    }

    @NotNull
    public ItemStack insertItemProxy(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.sourceHandler.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.sourceHandler.setStackInSlot(slot, reachedLimit ? stack.copyWithCount(limit) : stack);
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    public boolean isItemValid(int slot, ItemStack itemStack) {
        if (this.inventoryHolderBE == null) {
            return false;
        }
        if (this.inventoryHolderBE.automatedFiltersOnly) {
            return this.inventoryHolderBE.isStackValidFilter(itemStack, slot);
        }
        return this.sourceHandler.isItemValid(slot, itemStack);
    }

    public int getSlotLimit(int slot) {
        if (this.inventoryHolderBE == null) {
            return 0;
        }
        int allowedAmt = this.inventoryHolderBE.getSlotLimit(slot);
        if (allowedAmt == -1) {
            return 99;
        }
        return allowedAmt;
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        if (this.inventoryHolderBE == null) {
            return 0;
        }
        int allowedAmt = this.inventoryHolderBE.getSlotLimit(slot);
        if (allowedAmt == -1) {
            return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
        }
        return Math.min(allowedAmt, stack.getMaxStackSize());
    }

    public int getSlots() {
        return this.sourceHandler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        return this.sourceHandler.getStackInSlot(i);
    }
}

