/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.zlt.create_vibrant_vaults.block.ItemVaultConnectivityHelper;
import net.zlt.create_vibrant_vaults.block.ModBlockTags;
import net.zlt.create_vibrant_vaults.block.ModBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemVaultBlock.class})
public abstract class ItemVaultBlockMixin
extends Block
implements IWrenchable {
    private ItemVaultBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Redirect(method={"onWrenched"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/api/connectivity/ConnectivityHandler;splitMulti(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"), remap=false)
    private <T extends BlockEntity> void createVibrantVaults$onWrenchedSplitMulti(T be) {
        ItemVaultConnectivityHelper.splitItemVaultMulti(be);
    }

    @Redirect(method={"onRemove"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/api/connectivity/ConnectivityHandler;splitMulti(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"))
    private <T extends BlockEntity> void createVibrantVaults$onRemoveSplitMulti(T be) {
        ItemVaultConnectivityHelper.splitItemVaultMulti(be);
    }

    @Inject(method={"getVaultBlockAxis"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void createVibrantVaults$getVerticalVaultAxis(BlockState state, CallbackInfoReturnable<Direction.Axis> cir) {
        if (ModBlockTags.VERTICAL_VAULTS.matches(state)) {
            cir.setReturnValue((Object)Direction.Axis.Y);
        }
    }

    @Redirect(method={"getVaultBlockAxis"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/vault/ItemVaultBlock;isVault(Lnet/minecraft/world/level/block/state/BlockState;)Z"), remap=false)
    private static boolean createVibrantVaults$getVaultBlockAxisIsVault(BlockState state) {
        return ItemVaultConnectivityHelper.isVault(state);
    }

    @Redirect(method={"isLarge"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/vault/ItemVaultBlock;isVault(Lnet/minecraft/world/level/block/state/BlockState;)Z"), remap=false)
    private static boolean createVibrantVaults$isLargeIsVault(BlockState state) {
        return ItemVaultConnectivityHelper.isVault(state);
    }

    @Redirect(method={"getStateForPlacement"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/vault/ItemVaultBlock;getVaultBlockAxis(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/core/Direction$Axis;"))
    private Direction.Axis createVibrantVaults$getVaultPreferredAxis(BlockState state) {
        return ItemVaultConnectivityHelper.getItemVaultPreferredAxis(this, state);
    }

    @WrapOperation(method={"onWrenched"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/equipment/wrench/IWrenchable;onWrenched(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;")}, remap=false)
    private InteractionResult createVibrantVaults$onWrenched(ItemVaultBlock instance, BlockState state, UseOnContext context, Operation<InteractionResult> original) {
        if (!state.is((Block)AllBlocks.ITEM_VAULT.get())) {
            return (InteractionResult)original.call(new Object[]{instance, state, context});
        }
        Direction targetedFace = context.getClickedFace();
        if (!targetedFace.getAxis().isHorizontal() || targetedFace.getAxis() == state.getValue(ItemVaultBlock.HORIZONTAL_AXIS)) {
            return (InteractionResult)original.call(new Object[]{instance, state, context});
        }
        Level world = context.getLevel();
        BlockState rotated = ModBlocks.getVibrantVault(ModBlocks.VibrantVaultType.ITEM_VAULT, ModBlocks.VibrantVaultColor.BASE, true).getDefaultState();
        if (!rotated.canSurvive((LevelReader)world, context.getClickedPos())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)context.getClickedPos(), (BlockState)this.updateAfterWrenched(rotated, context));
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof GeneratingKineticBlockEntity) {
            GeneratingKineticBlockEntity be = (GeneratingKineticBlockEntity)blockEntity;
            be.reActivateSource = true;
        }
        if (world.getBlockState(context.getClickedPos()) != state) {
            IWrenchable.playRotateSound((Level)world, (BlockPos)context.getClickedPos());
        }
        return InteractionResult.SUCCESS;
    }
}

