/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.data;

import artifacts.Artifacts;
import artifacts.neoforge.data.LootTables;
import artifacts.registry.ModFeatures;
import artifacts.world.CampsiteChestConfiguration;
import artifacts.world.CampsiteFeatureConfiguration;
import artifacts.world.SuspiciousChestFeatureConfiguration;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;

public class ConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> CAMPSITE = Artifacts.key(Registries.CONFIGURED_FEATURE, "campsite");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MINIMALIST_CAMPSITE = Artifacts.key(Registries.CONFIGURED_FEATURE, "minimalist_campsite");

    public static void create(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        context.register(CAMPSITE, ConfiguredFeatures.createCampsite());
        context.register(MINIMALIST_CAMPSITE, ConfiguredFeatures.createMinimalistCampsite());
    }

    private static ConfiguredFeature<?, ?> createCampsite() {
        return new ConfiguredFeature(ModFeatures.CAMPSITE.get(), (FeatureConfiguration)new CampsiteFeatureConfiguration(ConfiguredFeatures.createChestConfig(0.125), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true))), 9).add((Object)((BlockState)Blocks.SOUL_CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true))), 1)), (BlockStateProvider)SimpleStateProvider.simple((BlockState)((BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)))), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.POTTED_DEAD_BUSH.defaultBlockState(), 2).add((Object)Blocks.POTTED_BAMBOO.defaultBlockState(), 2).add((Object)Blocks.POTTED_RED_TULIP.defaultBlockState(), 2).add((Object)Blocks.BREWING_STAND.defaultBlockState(), 1).add((Object)((BlockState)Blocks.CANDLE_CAKE.defaultBlockState().setValue((Property)CandleCakeBlock.LIT, (Comparable)Boolean.valueOf(true))), 1)), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.CRAFTING_TABLE.defaultBlockState(), 5).add((Object)Blocks.SMITHING_TABLE.defaultBlockState(), 5).add((Object)Blocks.FLETCHING_TABLE.defaultBlockState(), 5).add((Object)Blocks.CARTOGRAPHY_TABLE.defaultBlockState(), 5).add((Object)Blocks.ANVIL.defaultBlockState(), 2).add((Object)Blocks.CHIPPED_ANVIL.defaultBlockState(), 2).add((Object)Blocks.DAMAGED_ANVIL.defaultBlockState(), 1)), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)Blocks.FURNACE.defaultBlockState().setValue((Property)FurnaceBlock.LIT, (Comparable)Boolean.valueOf(false))), 2).add((Object)((BlockState)Blocks.BLAST_FURNACE.defaultBlockState().setValue((Property)BlastFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false))), 1).add((Object)((BlockState)Blocks.SMOKER.defaultBlockState().setValue((Property)SmokerBlock.LIT, (Comparable)Boolean.valueOf(false))), 1)), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.COBBLESTONE_WALL.defaultBlockState(), 2).add((Object)Blocks.COBBLED_DEEPSLATE_WALL.defaultBlockState(), 2).add((Object)Blocks.STONE_BRICK_WALL.defaultBlockState(), 1).add((Object)Blocks.DEEPSLATE_BRICK_WALL.defaultBlockState(), 1)), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.RED_BED.defaultBlockState(), 1).add((Object)Blocks.YELLOW_BED.defaultBlockState(), 1).add((Object)Blocks.CYAN_BED.defaultBlockState(), 1).add((Object)Blocks.GRAY_BED.defaultBlockState(), 1).add((Object)Blocks.MAGENTA_BED.defaultBlockState(), 1).add((Object)Blocks.GREEN_BED.defaultBlockState(), 1)), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.LANTERN.defaultBlockState(), 4).add((Object)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))), 1).add((Object)Blocks.SOUL_LANTERN.defaultBlockState(), 1)), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))), 1)), (BlockStateProvider)SimpleStateProvider.simple((Block)Blocks.OAK_PLANKS)));
    }

    private static ConfiguredFeature<?, ?> createMinimalistCampsite() {
        return new ConfiguredFeature(ModFeatures.SUSPICIOUS_CHEST.get(), (FeatureConfiguration)new SuspiciousChestFeatureConfiguration(ConfiguredFeatures.createChestConfig(0.0)));
    }

    private static CampsiteChestConfiguration createChestConfig(double trappedChestChance) {
        return new CampsiteChestConfiguration(Optional.empty(), trappedChestChance, Optional.of(LootTables.CHEST_LOOT));
    }
}

