/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.component.ability.DoubleJump;
import artifacts.equipment.EquipmentHelper;
import artifacts.network.DoubleJumpPacket;
import artifacts.network.NetworkHandler;
import artifacts.registry.ModDataComponents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CloudInABottleInputHandler {
    private static boolean canDoubleJump;
    private static boolean hasReleasedJumpKey;

    public static void onClientTick(Minecraft instance) {
        LocalPlayer player = instance.player;
        if (player != null && player.input != null) {
            CloudInABottleInputHandler.handleCloudInABottleInput(player);
        }
    }

    private static void handleCloudInABottleInput(LocalPlayer player) {
        if ((player.onGround() || player.onClimbable()) && (!player.isInWater() || EquipmentHelper.hasAbilityActive(ModDataComponents.SINKING.get(), (LivingEntity)player, true))) {
            hasReleasedJumpKey = false;
            canDoubleJump = true;
        } else if (!player.input.jumping) {
            hasReleasedJumpKey = true;
        } else if (!player.getAbilities().flying && canDoubleJump && hasReleasedJumpKey) {
            canDoubleJump = false;
            if (EquipmentHelper.hasAbilityActive(ModDataComponents.DOUBLE_JUMP.get(), (LivingEntity)player, true)) {
                NetworkHandler.sendToServer(new DoubleJumpPacket());
                DoubleJump.jump((Player)player);
            }
        }
    }
}

