/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.villagesandpillages.world.structures;

import com.faboslav.villagesandpillages.init.VillagesAndPillagesStructureTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawManager;
import com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.adaptations.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.adaptations.EnhancedTerrainAdaptationType;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class VillageWitchStructure
extends YungJigsawStructure {
    public static final int MAX_TOTAL_STRUCTURE_RADIUS = 128;
    public static final MapCodec<VillageWitchStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)VillageWitchStructure.settingsCodec((RecordCodecBuilder.Instance)builder), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)128).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)IntProvider.codec((int)0, (int)15).optionalFieldOf("x_offset_in_chunk", (Object)ConstantInt.of((int)0)).forGetter(structure -> structure.xOffsetInChunk), (App)IntProvider.codec((int)0, (int)15).optionalFieldOf("z_offset_in_chunk", (Object)ConstantInt.of((int)0)).forGetter(structure -> structure.zOffsetInChunk), (App)Codec.BOOL.optionalFieldOf("use_expansion_hack", (Object)false).forGetter(structure -> structure.useExpansionHack), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.INT.optionalFieldOf("max_y").forGetter(structure -> structure.maxY), (App)Codec.INT.optionalFieldOf("min_y").forGetter(structure -> structure.minY), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)DimensionPadding.ZERO).forGetter(structure -> structure.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)LiquidSettings.APPLY_WATERLOGGING).forGetter(structure -> structure.liquidSettings)).apply((Applicative)builder, VillageWitchStructure::new));
    public final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    public final int maxDepth;
    public final HeightProvider startHeight;
    public final IntProvider xOffsetInChunk;
    public final IntProvider zOffsetInChunk;
    public final boolean useExpansionHack;
    public final Optional<Heightmap.Types> projectStartToHeightmap;
    public final int maxDistanceFromCenter;
    public final Optional<Integer> maxY;
    public final Optional<Integer> minY;
    public final EnhancedTerrainAdaptation enhancedTerrainAdaptation;
    public final DimensionPadding dimensionPadding;
    public final LiquidSettings liquidSettings;

    public VillageWitchStructure(Structure.StructureSettings structureSettings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, IntProvider xOffsetInChunk, IntProvider zOffsetInChunk, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxBlockDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY, EnhancedTerrainAdaptation enhancedTerrainAdaptation, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(structureSettings, startPool, startJigsawName, maxDepth, startHeight, xOffsetInChunk, zOffsetInChunk, useExpansionHack, projectStartToHeightmap, maxBlockDistanceFromCenter, maxY, minY, enhancedTerrainAdaptation, dimensionPadding, liquidSettings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.xOffsetInChunk = xOffsetInChunk;
        this.zOffsetInChunk = zOffsetInChunk;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxBlockDistanceFromCenter;
        this.maxY = maxY;
        this.minY = minY;
        this.enhancedTerrainAdaptation = enhancedTerrainAdaptation;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int offsetY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        BlockPos blockPos = new BlockPos(context.chunkPos().getMinBlockX(), offsetY, context.chunkPos().getMinBlockZ());
        if (!this.extraSpawningChecks(context, blockPos)) {
            return Optional.empty();
        }
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom randomSource = context.random();
        int xOffset = this.xOffsetInChunk.sample((RandomSource)randomSource);
        int zOffset = this.zOffsetInChunk.sample((RandomSource)randomSource);
        int startY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        BlockPos startPos = new BlockPos(chunkPos.getBlockX(xOffset), startY, chunkPos.getBlockZ(zOffset));
        return YungJigsawManager.assembleJigsawStructure((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)startPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, this.maxY, this.minY, (DimensionPadding)JigsawStructure.DEFAULT_DIMENSION_PADDING, (LiquidSettings)JigsawStructure.DEFAULT_LIQUID_SETTINGS);
    }

    private boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        int checkRadius = 64;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int negativeFluidChecks = 0;
        for (int xOffset = -checkRadius; xOffset <= checkRadius; xOffset += 8) {
            for (int zOffset = -checkRadius; zOffset <= checkRadius; zOffset += 8) {
                int x = xOffset + blockPos.getX();
                int z = zOffset + blockPos.getZ();
                if (xOffset % checkRadius == 0 && zOffset % checkRadius == 0) {
                    Structure.GenerationStub structurePosition = new Structure.GenerationStub(new BlockPos(x, 68, z), collector -> {});
                    if (!this.isBiomeValid(structurePosition, context.chunkGenerator(), context.randomState(), arg_0 -> ((HolderSet)this.biomes()).contains(arg_0))) {
                        return false;
                    }
                }
                NoiseColumn blockView = context.chunkGenerator().getBaseColumn(x, z, context.heightAccessor(), context.randomState());
                mutable.set((Vec3i)blockPos).move(xOffset, -6, zOffset);
                if (!this.isViableBlockState(blockView.getBlock(mutable.getY())) || ++negativeFluidChecks <= 64) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isViableBlockState(BlockState blockState) {
        return !blockState.getFluidState().isEmpty() && blockState.is(Blocks.AIR);
    }

    private boolean isBiomeValid(Structure.GenerationStub result, ChunkGenerator chunkGenerator, RandomState noiseConfig, Predicate<Holder<Biome>> validBiomes) {
        BlockPos blockPos = result.position();
        return validBiomes.test((Holder<Biome>)chunkGenerator.getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)blockPos.getX()), QuartPos.fromBlock((int)blockPos.getY()), QuartPos.fromBlock((int)blockPos.getZ()), noiseConfig.sampler()));
    }

    public StructureType<?> type() {
        return VillagesAndPillagesStructureTypes.VILLAGE_WITCH_STRUCTURE;
    }
}

