/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.obsidianboat.entity;

import com.unrealdinnerbone.obsidianboat.OBRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ObsidianBoatEntity
extends Boat {
    public ObsidianBoatEntity(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = true;
    }

    public ObsidianBoatEntity(Level world, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)OBRegistry.ENTITY_TYPE.get()), world);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public ObsidianBoatEntity(Level level, Vec3 location) {
        this(level, location.x, location.y, location.z);
    }

    public ObsidianBoatEntity(Level worldIn) {
        this((EntityType<? extends Boat>)((EntityType)OBRegistry.ENTITY_TYPE.get()), worldIn);
    }

    public float getWaterLevelAbove() {
        AABB boundingBox = this.getBoundingBox();
        int minX = Mth.floor((double)boundingBox.minX);
        int maxX = Mth.ceil((double)boundingBox.maxX);
        int maxY = Mth.floor((double)boundingBox.maxY);
        int minY = Mth.ceil((double)(boundingBox.maxY - this.lastYd));
        int minZ = Mth.floor((double)boundingBox.minZ);
        int maxZ = Mth.ceil((double)boundingBox.maxZ);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int y = maxY; y < minY; ++y) {
            float f = 0.0f;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    blockPos.set(x, y, z);
                    FluidState fluidstate = this.level().getFluidState((BlockPos)blockPos);
                    if (!fluidstate.is(FluidTags.LAVA)) continue;
                    f = Math.max(f, fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)blockPos));
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockPos.getY() + f;
        }
        return minY + 1;
    }

    public boolean checkInWater() {
        AABB aabb = this.getBoundingBox();
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.ceil((double)aabb.maxX);
        int k = Mth.floor((double)aabb.minY);
        int l = Mth.ceil((double)(aabb.minY + 0.001));
        int i1 = Mth.floor((double)aabb.minZ);
        int j1 = Mth.ceil((double)aabb.maxZ);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.set(k1, l1, i2);
                    FluidState fluidstate = this.level().getFluidState((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.is(FluidTags.LAVA)) continue;
                    float f = (float)l1 + fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)blockpos$mutableblockpos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.minY < (double)f;
                }
            }
        }
        return flag;
    }

    public Boat.Status isUnderwater() {
        AABB aabb = this.getBoundingBox();
        double d0 = aabb.maxY + 0.001;
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.ceil((double)aabb.maxX);
        int k = Mth.floor((double)aabb.maxY);
        int l = Mth.ceil((double)d0);
        int i1 = Mth.floor((double)aabb.minZ);
        int j1 = Mth.ceil((double)aabb.maxZ);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.set(k1, l1, i2);
                    FluidState fluidstate = this.level().getFluidState((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.is(FluidTags.LAVA) || !(d0 < (double)((float)blockpos$mutableblockpos.getY() + fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.isSource()) {
                        return Boat.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Boat.Status.UNDER_WATER : null;
    }

    protected void checkFallDamage(double p_38307_, boolean p_38308_, BlockState p_38309_, BlockPos p_38310_) {
        this.lastYd = this.getDeltaMovement().y;
    }

    protected boolean canAddPassenger(Entity entity) {
        return this.getPassengers().size() < 2 && !this.isEyeInFluid(FluidTags.LAVA);
    }

    public void floatBoat() {
        double d0 = -0.04f;
        double d1 = this.isNoGravity() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.invFriction = 0.05f;
        if (this.oldStatus == Boat.Status.IN_AIR && this.status != Boat.Status.IN_AIR && this.status != Boat.Status.ON_LAND) {
            this.waterLevel = this.getY(1.0);
            this.setPos(this.getX(), (double)(this.getWaterLevelAbove() - this.getBbHeight()) + 0.101, this.getZ());
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Boat.Status.IN_WATER;
        } else {
            if (this.status == Boat.Status.IN_WATER) {
                d2 = (this.waterLevel - this.getY()) / (double)this.getBbHeight() + 0.35;
                this.invFriction = 0.9f;
            } else if (this.status == Boat.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.invFriction = 0.9f;
            } else if (this.status == Boat.Status.UNDER_WATER) {
                d2 = 0.01f;
                this.invFriction = 0.45f;
            } else if (this.status == Boat.Status.IN_AIR) {
                this.invFriction = 0.9f;
            } else if (this.status == Boat.Status.ON_LAND) {
                this.invFriction = this.landFriction;
                if (this.getControllingPassenger() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3 vector3d = this.getDeltaMovement();
            this.setDeltaMovement(vector3d.x * (double)this.invFriction, vector3d.y + d1, vector3d.z * (double)this.invFriction);
            this.deltaRotation *= this.invFriction;
            if (d2 > 0.0) {
                Vec3 vector3d1 = this.getDeltaMovement();
                this.setDeltaMovement(vector3d1.x, (vector3d1.y + d2 * 0.06153846016296973) * 0.75, vector3d1.z);
            }
        }
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    @NotNull
    public Item getDropItem() {
        return (Item)OBRegistry.BOAT_ITEM.get();
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    @NotNull
    public Boat.Type getVariant() {
        return Boat.Type.OAK;
    }
}

