/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import rbasamoyai.escalated.config.EscalatedConfigs;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedBlockEntities;
import rbasamoyai.escalated.index.EscalatedTriggers;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayHelper;
import rbasamoyai.escalated.walkways.WalkwayMovementHandler;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public abstract class AbstractWalkwayBlock
extends HorizontalKineticBlock
implements IBE<WalkwayBlockEntity>,
WalkwayBlock {
    private final NonNullSupplier<WalkwaySet> walkwaySetSupplier;
    private WalkwaySet walkwaySet = null;

    protected AbstractWalkwayBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties);
        this.walkwaySetSupplier = walkwaySetSupplier;
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.getValue(HORIZONTAL_FACING);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getClockWise().getAxis();
    }

    public Class<WalkwayBlockEntity> getBlockEntityClass() {
        return WalkwayBlockEntity.class;
    }

    public BlockEntityType<? extends WalkwayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EscalatedBlockEntities.WALKWAY.get();
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        this.transportEntity(level, pos, state, entity);
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        BlockPos actualPos = entity.getOnPos();
        BlockState actualState = level.getBlockState(actualPos);
        this.transportEntity(level, actualPos, actualState, entity);
    }

    protected void transportEntity(Level level, BlockPos pos, BlockState state, Entity entity) {
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).isShiftKeyDown() || player.getAbilities().flying)) {
            return;
        }
        if (((Boolean)EscalatedConfigs.SERVER.divingBootsPreventWalkwayMotion.get()).booleanValue() && DivingBootsItem.isWornBy((Entity)entity)) {
            return;
        }
        WalkwayBlockEntity walkway = WalkwayHelper.getSegmentBE((LevelAccessor)level, pos);
        if (walkway == null) {
            return;
        }
        WalkwayBlockEntity controller = WalkwayHelper.getControllerBE((LevelAccessor)level, pos);
        if (controller == null || controller.passengers == null) {
            return;
        }
        if (controller.passengers.containsKey(entity)) {
            WalkwayMovementHandler.TransportedEntityInfo info = controller.passengers.get(entity);
            if (info.getTicksSinceLastCollision() != 0 || pos.equals((Object)entity.blockPosition())) {
                info.refresh(pos, state);
            }
        } else {
            controller.passengers.put(entity, new WalkwayMovementHandler.TransportedEntityInfo(pos, state));
            entity.setOnGround(true);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        block32: {
            boolean connectedRight;
            boolean connectedLeft;
            Direction left;
            block31: {
                Direction facing = this.getFacing(state);
                left = facing.getCounterClockWise();
                connectedLeft = this.connectedToWalkwayOnSide(level, state, pos, left);
                connectedRight = this.connectedToWalkwayOnSide(level, state, pos, left.getOpposite());
                super.onRemove(state, level, pos, newState, isMoving);
                if (level.isClientSide || state.getBlock() == newState.getBlock() || this.getWalkwaySet().blockInSet(newState) || isMoving) {
                    return;
                }
                WalkwayBlock walkwayBlock = this;
                BlockState currentState = state;
                for (Direction dir : Iterate.directionsInAxis((Direction.Axis)left.getAxis())) {
                    WalkwayBlockEntity sideWalkwayBE;
                    WalkwayBlock sideWalkway;
                    BlockPos sidePos = pos.relative(dir);
                    BlockState sideState = level.getBlockState(sidePos);
                    Block block = sideState.getBlock();
                    if (!(block instanceof WalkwayBlock) || !(sideWalkway = (WalkwayBlock)block).connectedToWalkwayOnSide(level, sideState, sidePos, dir.getOpposite())) continue;
                    boolean sideShaft = sideWalkway.hasWalkwayShaft(sideState);
                    BlockState transformState = sideWalkway.transformFromMerge(level, sideState, sidePos, dir != left, sideShaft, true, false);
                    DyeColor color = null;
                    float visualProgress = 0.0f;
                    BlockEntity blockEntity = level.getBlockEntity(sidePos);
                    if (blockEntity instanceof WalkwayBlockEntity) {
                        sideWalkwayBE = (WalkwayBlockEntity)blockEntity;
                        color = sideWalkwayBE.getColor();
                        visualProgress = sideWalkwayBE.getVisualProgress();
                    }
                    KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)sidePos, (BlockState)transformState);
                    blockEntity = level.getBlockEntity(sidePos);
                    if (!(blockEntity instanceof WalkwayBlockEntity)) continue;
                    sideWalkwayBE = (WalkwayBlockEntity)blockEntity;
                    sideWalkwayBE.applyColor(color);
                    sideWalkwayBE.setVisualProgress(visualProgress);
                    sideWalkwayBE.resetClientRender = true;
                    sideWalkwayBE.notifyUpdate();
                }
                boolean terminal = this.getWalkwaySlope(state) == WalkwaySlope.TERMINAL;
                for (boolean forward : Iterate.trueAndFalse) {
                    WalkwayBlock newWalkway;
                    Block sideShaft;
                    BlockPos currentPos = WalkwayBlock.nextSegmentPosition(state, pos, forward, terminal && !forward);
                    if (currentPos == null || !((sideShaft = (currentState = level.getBlockState(currentPos)).getBlock()) instanceof WalkwayBlock)) continue;
                    walkwayBlock = newWalkway = (WalkwayBlock)sideShaft;
                    boolean hasPulley = walkwayBlock.hasWalkwayShaft(currentState);
                    level.removeBlockEntity(currentPos);
                    Object shaftState = (BlockState)AllBlocks.SHAFT.getDefaultState().setValue((Property)BlockStateProperties.AXIS, (Comparable)this.getRotationAxis(currentState));
                    level.setBlock(currentPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((boolean[])(hasPulley ? shaftState : (boolean[])Blocks.AIR.defaultBlockState())), (BlockPos)currentPos), 3);
                    level.levelEvent(2001, currentPos, Block.getId((BlockState)currentState));
                }
                BlockPos abovePos = pos.above();
                BlockState aboveState = level.getBlockState(abovePos);
                if (!(aboveState.getBlock() instanceof AbstractHandrailBlock)) break block31;
                AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)aboveState.getValue(AbstractHandrailBlock.SIDE));
                if (side == AbstractHandrailBlock.Side.BOTH) {
                    level.destroyBlock(abovePos, true);
                } else {
                    Direction offsetDir;
                    ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                    positions.add(abovePos);
                    BlockPos iterPos = abovePos;
                    BlockState iterState = aboveState;
                    int MAX_ITER = 1100;
                    for (boolean forward : Iterate.trueAndFalse) {
                        iterPos = abovePos;
                        iterState = aboveState;
                        for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = level.getBlockState(iterPos)).getBlock() instanceof AbstractHandrailBlock; ++i) {
                            positions.add(iterPos);
                        }
                    }
                    BlockEntity color = level.getBlockEntity(abovePos);
                    if (!(color instanceof HandrailBlockEntity)) {
                        return;
                    }
                    HandrailBlockEntity handrailBE = (HandrailBlockEntity)color;
                    int handrailWidth = handrailBE.width;
                    Direction handrailLeft = ((Direction)aboveState.getValue((Property)AbstractHandrailBlock.FACING)).getCounterClockWise();
                    Direction direction = offsetDir = side == AbstractHandrailBlock.Side.LEFT ? handrailLeft.getOpposite() : handrailLeft;
                    if (handrailWidth == 2) {
                        for (BlockPos handrailPos : positions) {
                            BlockPos newHandrailPos = handrailPos.relative(offsetDir);
                            BlockState oldHandrailState = level.getBlockState(newHandrailPos);
                            if (!(oldHandrailState.getBlock() instanceof AbstractHandrailBlock)) continue;
                            level.setBlock(newHandrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)oldHandrailState.setValue(AbstractHandrailBlock.SIDE, (Comparable)((Object)AbstractHandrailBlock.Side.BOTH))), (BlockPos)newHandrailPos), 3);
                            BlockEntity blockEntity = level.getBlockEntity(handrailPos);
                            if (blockEntity instanceof HandrailBlockEntity) {
                                HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)blockEntity;
                                handrailBE1.propagateBreak = false;
                            }
                            level.setBlock(handrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)Blocks.AIR.defaultBlockState(), (BlockPos)handrailPos), 3);
                            level.levelEvent(2001, handrailPos, Block.getId((BlockState)oldHandrailState));
                        }
                    } else {
                        BlockPos newHandrailPos;
                        for (BlockPos handrailPos : positions) {
                            newHandrailPos = handrailPos.relative(offsetDir);
                            if (level.getBlockState(newHandrailPos).canBeReplaced()) continue;
                            level.destroyBlock(abovePos, true);
                            return;
                        }
                        for (BlockPos handrailPos : positions) {
                            newHandrailPos = handrailPos.relative(offsetDir);
                            BlockState placeState = level.getBlockState(handrailPos);
                            level.destroyBlock(newHandrailPos, true);
                            level.setBlock(newHandrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)placeState, (BlockPos)newHandrailPos), 3);
                            BlockEntity blockEntity = level.getBlockEntity(newHandrailPos);
                            if (blockEntity instanceof HandrailBlockEntity) {
                                HandrailBlockEntity newHandrailBE = (HandrailBlockEntity)blockEntity;
                                blockEntity = level.getBlockEntity(handrailPos);
                                if (blockEntity instanceof HandrailBlockEntity) {
                                    HandrailBlockEntity oldHandrailBE = (HandrailBlockEntity)blockEntity;
                                    newHandrailBE.width = handrailWidth - 1;
                                    oldHandrailBE.width = 0;
                                    oldHandrailBE.propagateBreak = false;
                                    BlockEntity blockEntity2 = level.getBlockEntity(newHandrailPos.relative(offsetDir, handrailWidth - 1));
                                    if (blockEntity2 instanceof HandrailBlockEntity) {
                                        HandrailBlockEntity oppositeHandrailBE = (HandrailBlockEntity)blockEntity2;
                                        oppositeHandrailBE.width = newHandrailBE.width;
                                    }
                                }
                            }
                            level.setBlock(handrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)Blocks.AIR.defaultBlockState(), (BlockPos)handrailPos), 3);
                            level.levelEvent(2001, abovePos, Block.getId((BlockState)placeState));
                        }
                    }
                }
                break block32;
            }
            if (!connectedLeft || !connectedRight) break block32;
            for (Direction dir : Iterate.directionsInAxis((Direction.Axis)left.getAxis())) {
                BlockEntity newHandrailPos;
                BlockPos abovePos1;
                BlockState aboveState1;
                int offset;
                int MAX_ITER = 256;
                BlockPos offsetPos = pos.relative(dir, offset);
                BlockState offsetState = level.getBlockState(offsetPos);
                for (offset = 1; offset < MAX_ITER; ++offset) {
                    offsetPos = pos.relative(dir, offset);
                    offsetState = level.getBlockState(offsetPos);
                    Block i = offsetState.getBlock();
                    if (!(i instanceof WalkwayBlock)) {
                        return;
                    }
                    WalkwayBlock offsetWalkway = (WalkwayBlock)i;
                    if (!offsetWalkway.connectedToWalkwayOnSide(level, offsetState, offsetPos, dir)) break;
                }
                if (!((aboveState1 = level.getBlockState(abovePos1 = offsetPos.above())).getBlock() instanceof AbstractHandrailBlock) || !((newHandrailPos = level.getBlockEntity(abovePos1)) instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)newHandrailPos;
                if (handrailBE.width == offset) continue;
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                positions.add(abovePos1);
                for (boolean forward : Iterate.trueAndFalse) {
                    BlockPos iterPos = abovePos1;
                    BlockState iterState = aboveState1;
                    for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = level.getBlockState(iterPos)).getBlock() instanceof AbstractHandrailBlock; ++i) {
                        positions.add(iterPos);
                    }
                }
                if (offset > 1) {
                    boolean fail = false;
                    for (BlockPos handrailPos : positions) {
                        BlockPos otherHandrailPos = handrailPos.relative(dir, -offset + 1);
                        if (level.getBlockState(otherHandrailPos).canBeReplaced()) continue;
                        fail = true;
                        break;
                    }
                    if (fail) {
                        for (BlockPos handrailPos : positions) {
                            BlockEntity i = level.getBlockEntity(handrailPos);
                            if (i instanceof HandrailBlockEntity) {
                                HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)i;
                                handrailBE1.propagateBreak = false;
                            }
                            level.destroyBlock(handrailPos, true);
                        }
                        continue;
                    }
                    for (BlockPos handrailPos : positions) {
                        BlockEntity i = level.getBlockEntity(handrailPos);
                        if (i instanceof HandrailBlockEntity) {
                            HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)i;
                            handrailBE1.width = offset;
                        }
                        BlockState srcHandrailState = level.getBlockState(handrailPos);
                        BlockPos otherHandrailPos = handrailPos.relative(dir, -offset + 1);
                        level.destroyBlock(otherHandrailPos, true);
                        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)srcHandrailState.getValue(AbstractHandrailBlock.SIDE));
                        AbstractHandrailBlock.Side placeSide = side == AbstractHandrailBlock.Side.LEFT ? AbstractHandrailBlock.Side.RIGHT : AbstractHandrailBlock.Side.LEFT;
                        level.setBlock(otherHandrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)srcHandrailState.setValue(AbstractHandrailBlock.SIDE, (Comparable)((Object)placeSide))), (BlockPos)otherHandrailPos), 3);
                        BlockEntity blockEntity = level.getBlockEntity(otherHandrailPos);
                        if (!(blockEntity instanceof HandrailBlockEntity)) continue;
                        HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)blockEntity;
                        handrailBE1.width = offset;
                    }
                    continue;
                }
                for (BlockPos handrailPos : positions) {
                    BlockState handrailState = level.getBlockState(handrailPos);
                    level.setBlock(handrailPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)handrailState.setValue(AbstractHandrailBlock.SIDE, (Comparable)((Object)AbstractHandrailBlock.Side.BOTH))), (BlockPos)handrailPos), 3);
                    BlockEntity blockEntity = level.getBlockEntity(handrailPos);
                    if (!(blockEntity instanceof HandrailBlockEntity)) continue;
                    HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)blockEntity;
                    handrailBE1.width = 1;
                }
            }
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        if (this.hasWalkwayShaft(state)) {
            drops.addAll(AllBlocks.SHAFT.getDefaultState().getDrops(builder));
        }
        return drops;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean isDye = WalkwayHelper.isDye(stack);
        boolean hasWater = WalkwayHelper.hasWater(level, stack);
        if (isDye || hasWater) {
            return this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> be.applyColor(WalkwayHelper.getDyeColorFromItem(stack)) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
        }
        boolean isBelt = WalkwayHelper.isHandrail(stack);
        if (isBelt) {
            return this.placeHandrail(level, state, pos, player, stack) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean placeHandrail(Level level, BlockState state, BlockPos pos, Player player, ItemStack itemStack) {
        BlockEntity leftPos;
        BlockPos centralPos = pos;
        BlockState referenceState = state;
        if (this.getWalkwaySlope(referenceState) == WalkwaySlope.TERMINAL && !((referenceState = level.getBlockState(centralPos = pos.relative(this.getFacing(referenceState)))).getBlock() instanceof WalkwayBlock)) {
            return false;
        }
        WalkwayBlock walkway = (WalkwayBlock)referenceState.getBlock();
        Direction dir = walkway.getFacing(referenceState);
        AbstractHandrailBlock handrail = (AbstractHandrailBlock)walkway.getWalkwaySet().getHandrailBlock(level, referenceState, centralPos).getBlock();
        int MAX_ITER = 1100;
        if (!walkway.connectedToWalkwayOnSide(level, referenceState, pos, dir.getClockWise()) && !walkway.connectedToWalkwayOnSide(level, referenceState, pos, dir.getCounterClockWise())) {
            void var17_25;
            if (level.getBlockState(centralPos.above()).getBlock() instanceof AbstractHandrailBlock) {
                return false;
            }
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            BlockState iterState = referenceState;
            BlockPos iterPos = centralPos;
            positions.add(iterPos);
            Object object = Iterate.trueAndFalse;
            int n = ((boolean[])object).length;
            boolean bl = false;
            while (var17_25 < n) {
                boolean forward = object[var17_25];
                iterState = referenceState;
                iterPos = centralPos;
                for (int i = 0; i < MAX_ITER && (iterPos = WalkwayBlock.nextSegmentPosition(iterState, iterPos, forward, true)) != null; ++i) {
                    iterState = level.getBlockState(iterPos);
                    if (!(iterState.getBlock() instanceof WalkwayBlock) || !level.getBlockState(iterPos.above()).canBeReplaced()) {
                        return false;
                    }
                    positions.add(iterPos);
                }
                ++var17_25;
            }
            object = positions.iterator();
            while (object.hasNext()) {
                BlockPos basePos = (BlockPos)object.next();
                BlockState blockState = level.getBlockState(basePos);
                WalkwayBlock otherWalkway = (WalkwayBlock)blockState.getBlock();
                BlockPos abovePos = basePos.above();
                BlockState placeState = handrail.getStateForSlope(level, basePos, blockState, abovePos, dir, otherWalkway.getWalkwaySlope(blockState), AbstractHandrailBlock.Side.BOTH);
                level.destroyBlock(abovePos, true);
                level.setBlock(abovePos, placeState, 3);
            }
            level.playSound(null, pos.above(), SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 0.5f, 1.0f);
            EscalatedTriggers.HANDRAIL.tryAwardingTo(player);
            return true;
        }
        Direction left = dir.getCounterClockWise();
        for (int i = 0; i < MAX_ITER; ++i) {
            leftPos = centralPos.relative(left, i);
            BlockState leftState = level.getBlockState((BlockPos)leftPos);
            Block block = leftState.getBlock();
            if (!(block instanceof WalkwayBlock)) {
                return false;
            }
            WalkwayBlock leftWalkway = (WalkwayBlock)block;
            if (leftWalkway.connectedToWalkwayOnSide(level, leftState, (BlockPos)leftPos, left)) continue;
            referenceState = leftState;
            centralPos = leftPos;
            break;
        }
        if (!((leftPos = level.getBlockEntity(centralPos)) instanceof WalkwayBlockEntity)) {
            return false;
        }
        WalkwayBlockEntity centralBE = (WalkwayBlockEntity)leftPos;
        if (level.getBlockState(centralPos.above()).getBlock() instanceof AbstractHandrailBlock) {
            return false;
        }
        ArrayList<BlockPos> leftPositions = new ArrayList<BlockPos>();
        BlockState iterState = referenceState;
        BlockPos iterPos = centralPos;
        leftPositions.add(iterPos);
        for (boolean forward : Iterate.trueAndFalse) {
            iterState = referenceState;
            iterPos = centralPos;
            for (int i = 0; i < MAX_ITER && (iterPos = WalkwayBlock.nextSegmentPosition(iterState, iterPos, forward, true)) != null; ++i) {
                iterState = level.getBlockState(iterPos);
                if (!(iterState.getBlock() instanceof WalkwayBlock) || !level.getBlockState(iterPos.above()).canBeReplaced()) {
                    return false;
                }
                leftPositions.add(iterPos);
            }
        }
        WalkwayBlockEntity walkwayBlockEntity = centralBE.getControllerBE();
        if (walkwayBlockEntity == null) {
            return false;
        }
        int width = walkwayBlockEntity.walkwayWidth;
        int offset = width - 1;
        referenceState = level.getBlockState(centralPos = centralPos.relative(left, -offset));
        if (!(referenceState.getBlock() instanceof WalkwayBlock)) {
            return false;
        }
        for (BlockPos leftBasePos : leftPositions) {
            BlockPos rightAbovePos = leftBasePos.relative(left, -offset).above();
            if (level.getBlockState(leftBasePos.above()).canBeReplaced() && level.getBlockState(rightAbovePos).canBeReplaced()) continue;
            return false;
        }
        for (BlockPos leftBasePos : leftPositions) {
            BlockState leftBaseState = level.getBlockState(leftBasePos);
            WalkwayBlock otherWalkway = (WalkwayBlock)leftBaseState.getBlock();
            BlockPos leftAbovePos = leftBasePos.above();
            BlockState leftPlaceState = handrail.getStateForSlope(level, leftBasePos, leftBaseState, leftAbovePos, dir, otherWalkway.getWalkwaySlope(leftBaseState), AbstractHandrailBlock.Side.LEFT);
            level.destroyBlock(leftAbovePos, true);
            level.setBlock(leftAbovePos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)leftPlaceState, (BlockPos)leftAbovePos), 3);
            BlockEntity blockEntity = level.getBlockEntity(leftAbovePos);
            if (blockEntity instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)blockEntity;
                handrailBE.width = width;
            }
            BlockPos rightBasePos = leftBasePos.relative(left, -offset);
            BlockState rightBaseState = level.getBlockState(rightBasePos);
            BlockPos rightAbovePos = rightBasePos.above();
            BlockState rightPlaceState = handrail.getStateForSlope(level, rightBasePos, rightBaseState, rightAbovePos, dir, otherWalkway.getWalkwaySlope(rightBaseState), AbstractHandrailBlock.Side.RIGHT);
            level.destroyBlock(rightAbovePos, true);
            level.setBlock(rightAbovePos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)rightPlaceState, (BlockPos)rightAbovePos), 3);
            BlockEntity blockEntity2 = level.getBlockEntity(rightAbovePos);
            if (!(blockEntity2 instanceof HandrailBlockEntity)) continue;
            HandrailBlockEntity handrailBE = (HandrailBlockEntity)blockEntity2;
            handrailBE.width = width;
        }
        level.playSound(null, pos.above(), SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 0.5f, 1.0f);
        EscalatedTriggers.HANDRAIL.tryAwardingTo(player);
        return true;
    }

    @Override
    public WalkwaySet getWalkwaySet() {
        if (this.walkwaySet == null) {
            this.walkwaySet = (WalkwaySet)this.walkwaySetSupplier.get();
        }
        return this.walkwaySet;
    }
}

