/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification.selection.selectors;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelectorSerializers;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;

public record NamesResourceSelector(Set<ResourceLocation> names) implements ResourceSelector<NamesResourceSelector>
{
    public NamesResourceSelector(ResourceLocation ... names) {
        this(Set.of(names));
    }

    public NamesResourceSelector(String ... names) {
        this(Stream.of(names).map(ResourceLocation::parse).collect(Collectors.toSet()));
    }

    @Override
    public Either<Set<ResourceLocation>, Predicate<ResourceLocation>> select() {
        return Either.left(this.names);
    }

    public Serializer getSerializer() {
        return ResourceSelectorSerializers.NAMES;
    }

    public static final class Serializer
    implements ResourceSelector.Serializer<NamesResourceSelector> {
        @Override
        public JsonElement serialize(NamesResourceSelector selector) {
            JsonArray jsonArray = new JsonArray();
            selector.names.forEach(location -> jsonArray.add(location.toString()));
            return jsonArray;
        }

        @Override
        public NamesResourceSelector deserialize(JsonElement element) {
            JsonArray jsonArray = element.getAsJsonArray();
            HashSet<ResourceLocation> names = new HashSet<ResourceLocation>();
            jsonArray.forEach(nameElement -> names.add(ResourceLocation.parse((String)nameElement.getAsString())));
            return new NamesResourceSelector(names);
        }
    }
}

