/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.item;

import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ItemStackUtil {
    private static final String[] M_NUMERALS = new String[]{"", "M", "MM", "MMM"};
    private static final String[] C_NUMERALS = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
    private static final String[] X_NUMERALS = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
    private static final String[] I_NUMERALS = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};

    public static int findIndexOfItem(Item item, NonNullList<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            if (((ItemStack)items.get(i)).getItem() != item) continue;
            return i;
        }
        return -1;
    }

    public static String intToRomanNumerals(int number) {
        String thousands = M_NUMERALS[number / 1000];
        String hundreds = C_NUMERALS[number % 1000 / 100];
        String tens = X_NUMERALS[number % 100 / 10];
        String ones = I_NUMERALS[number % 10];
        return thousands + hundreds + tens + ones;
    }

    public static Predicate<ItemStack> is(Class<? extends Item> clazz) {
        return stack -> clazz.isInstance(stack.getItem());
    }
}

