/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.registry;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

public final class BlueprintBoatTypes {
    public static final ResourceLocation UNDEFINED_BOAT_LOCATION = ResourceLocation.withDefaultNamespace((String)"oak");
    private static final Map<ResourceLocation, BlueprintBoatType> BOATS = new HashMap<ResourceLocation, BlueprintBoatType>();

    public static synchronized void registerType(ResourceLocation name, Supplier<Item> boat, Supplier<Item> chestBoat, Supplier<Block> plank, boolean raft) {
        BOATS.put(name, new BlueprintBoatType(name, boat, chestBoat, plank, raft));
    }

    @Nullable
    public static BlueprintBoatType getType(ResourceLocation name) {
        return BOATS.get(name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition boatModel = BoatModel.createBodyModel();
        LayerDefinition chestBoatModel = ChestBoatModel.createBodyModel();
        LayerDefinition raftModel = RaftModel.createBodyModel();
        LayerDefinition chestRaftModel = ChestRaftModel.createBodyModel();
        BOATS.forEach((name, type) -> {
            if (name == UNDEFINED_BOAT_LOCATION) {
                return;
            }
            boolean isRaft = type.isRaft();
            event.registerLayerDefinition(type.getBoatModelLayerLocation(), isRaft ? () -> raftModel : () -> boatModel);
            event.registerLayerDefinition(type.getChestBoatModelLayerLocation(), isRaft ? () -> chestRaftModel : () -> chestBoatModel);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IdentityHashMap<BlueprintBoatType, Pair<ResourceLocation, ListModel<Boat>>> createBoatResources(EntityRendererProvider.Context context, boolean chest) {
        IdentityHashMap<BlueprintBoatType, Pair<ResourceLocation, ListModel<Boat>>> boatTypeToModel = new IdentityHashMap<BlueprintBoatType, Pair<ResourceLocation, ListModel<Boat>>>();
        BOATS.values().forEach(type -> boatTypeToModel.put((BlueprintBoatType)type, (Pair<ResourceLocation, ListModel<Boat>>)Pair.of((Object)(chest ? type.getChestVariantTexture() : type.getTexture()), BlueprintBoatTypes.createBoatModel(context, type, chest))));
        return boatTypeToModel;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, BlueprintBoatType type, boolean chest) {
        ModelPart modelpart = context.bakeLayer(chest ? type.getChestBoatModelLayerLocation() : type.getBoatModelLayerLocation());
        if (type.isRaft()) {
            return chest ? new ChestRaftModel(modelpart) : new RaftModel(modelpart);
        }
        return chest ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    static {
        BlueprintBoatTypes.registerType(UNDEFINED_BOAT_LOCATION, () -> Items.OAK_BOAT, () -> Items.OAK_CHEST_BOAT, () -> Blocks.OAK_PLANKS, false);
    }

    public static class BlueprintBoatType {
        private final ResourceLocation name;
        private final Supplier<Item> boat;
        private final Supplier<Item> chestBoat;
        private final Supplier<Block> plank;
        private final boolean raft;
        private final ResourceLocation texture;
        private final ResourceLocation chestVariantTexture;

        public BlueprintBoatType(ResourceLocation name, Supplier<Item> boat, Supplier<Item> chestBoat, Supplier<Block> plank, boolean raft) {
            this.name = name;
            this.boat = boat;
            this.chestBoat = chestBoat;
            this.plank = plank;
            this.raft = raft;
            String namespace = name.getNamespace();
            String path = name.getPath();
            this.texture = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("textures/entity/boat/" + path + ".png"));
            this.chestVariantTexture = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("textures/entity/chest_boat/" + path + ".png"));
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public Item getBoatItem() {
            return this.boat.get();
        }

        public Item getChestBoatItem() {
            return this.chestBoat.get();
        }

        public Item getPlankItem() {
            return this.plank.get().asItem();
        }

        public boolean isRaft() {
            return this.raft;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public ResourceLocation getChestVariantTexture() {
            return this.chestVariantTexture;
        }

        @OnlyIn(value=Dist.CLIENT)
        public ModelLayerLocation getBoatModelLayerLocation() {
            ResourceLocation name = this.getName();
            String namespace = name.getNamespace();
            String path = name.getPath();
            return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("boat/" + path)), "main");
        }

        @OnlyIn(value=Dist.CLIENT)
        public ModelLayerLocation getChestBoatModelLayerLocation() {
            ResourceLocation name = this.getName();
            String namespace = name.getNamespace();
            String path = name.getPath();
            return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("chest_boat/" + path)), "main");
        }
    }
}

