/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator.interpolation;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.endimator.EndimationKeyframe;
import com.teamabnormals.blueprint.core.util.registry.BasicRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

@FunctionalInterface
public interface InterpolationType {
    public static final Registry REGISTRY = new Registry();
    public static final InterpolationType LINEAR = REGISTRY.register("linear", (vec3, keyframes, from, to, index, keyframeCount, progress) -> vec3.set(Mth.lerp((float)progress, (float)from.postX.get().floatValue(), (float)to.preX.get().floatValue()), Mth.lerp((float)progress, (float)from.postY.get().floatValue(), (float)to.preY.get().floatValue()), Mth.lerp((float)progress, (float)from.postZ.get().floatValue(), (float)to.preZ.get().floatValue())));
    public static final InterpolationType CATMULL_ROM = REGISTRY.register("catmullrom", (vec3, keyframes, from, to, index, keyframeCount, progress) -> {
        float fromX = from.postX.get().floatValue();
        float fromY = from.postY.get().floatValue();
        float fromZ = from.postZ.get().floatValue();
        float oldFromX = fromX;
        float oldFromY = fromY;
        float oldFromZ = fromZ;
        int previousFromIndex = index - 2;
        if (previousFromIndex >= 0) {
            EndimationKeyframe oldFrom = keyframes[previousFromIndex];
            oldFromX = oldFrom.postX.get().floatValue();
            oldFromY = oldFrom.postY.get().floatValue();
            oldFromZ = oldFrom.postZ.get().floatValue();
        }
        float toX = to.preX.get().floatValue();
        float toY = to.preY.get().floatValue();
        float toZ = to.preZ.get().floatValue();
        float nextToX = toX;
        float nextToY = toY;
        float nextToZ = toZ;
        int nextToIndex = index + 1;
        if (nextToIndex < keyframeCount) {
            EndimationKeyframe nextTo = keyframes[nextToIndex];
            nextToX = nextTo.preX.get().floatValue();
            nextToY = nextTo.preY.get().floatValue();
            nextToZ = nextTo.preZ.get().floatValue();
        }
        vec3.set(Mth.catmullrom((float)progress, (float)oldFromX, (float)fromX, (float)toX, (float)nextToX), InterpolationType.catmullRom(progress, oldFromY, fromY, toY, nextToY), InterpolationType.catmullRom(progress, oldFromZ, fromZ, toZ, nextToZ));
    });

    @Deprecated(forRemoval=true)
    public static float catmullRom(float progress, float p0, float p1, float p2, float p3) {
        return 0.5f * (2.0f * p1 + (p2 - p0) * progress + (2.0f * p0 - 5.0f * p1 + 4.0f * p2 - p3) * progress * progress + (3.0f * p1 - p0 - 3.0f * p2 + p3) * progress * progress * progress);
    }

    public void apply(Vector3f var1, EndimationKeyframe[] var2, EndimationKeyframe var3, EndimationKeyframe var4, int var5, int var6, float var7);

    public static final class Registry {
        private final BasicRegistry<InterpolationType> registry = new BasicRegistry();

        private InterpolationType register(String name, InterpolationType interpolationType) {
            this.registry.register(name, interpolationType);
            return interpolationType;
        }

        public synchronized InterpolationType register(ResourceLocation name, InterpolationType interpolationType) {
            return this.register(name.toString(), interpolationType);
        }

        public Codec<InterpolationType> asCodec() {
            return this.registry;
        }
    }
}

