/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator.effects;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.endimator.effects.EndimationEffect;
import com.teamabnormals.blueprint.core.endimator.effects.EndimationEffectSource;
import com.teamabnormals.blueprint.core.endimator.effects.EndimationEffects;

public final class ConfiguredEndimationEffect<C, E extends EndimationEffect<C>>
implements Comparable<ConfiguredEndimationEffect<?, ?>> {
    public static final Codec<ConfiguredEndimationEffect<?, ?>> CODEC = EndimationEffects.REGISTRY.dispatch(ConfiguredEndimationEffect::getEffect, EndimationEffect::getCodec);
    private final E effect;
    private final C config;
    private final float time;

    public ConfiguredEndimationEffect(E effect, C config, float time) {
        this.effect = effect;
        this.config = config;
        this.time = time;
    }

    public void process(EndimationEffectSource source, float time) {
        ((EndimationEffect)this.effect).process(source, time, this.config);
    }

    public E getEffect() {
        return this.effect;
    }

    public C getConfig() {
        return this.config;
    }

    public float getTime() {
        return this.time;
    }

    @Override
    public int compareTo(ConfiguredEndimationEffect<?, ?> other) {
        return Float.compare(this.time, other.time);
    }
}

