/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.teamabnormals.blueprint.core.api.conditions.config.IConfigPredicate;
import com.teamabnormals.blueprint.core.api.conditions.config.IConfigPredicateSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.conditions.ICondition;

public class ConfigValueCondition
implements ICondition {
    private final MapCodec<ConfigValueCondition> codec;
    private final ModConfigSpec.ConfigValue<?> value;
    private final String valueID;
    private final Map<IConfigPredicate, Boolean> predicates;
    private final boolean inverted;

    public ConfigValueCondition(MapCodec<ConfigValueCondition> codec, ModConfigSpec.ConfigValue<?> value, String valueID, Map<IConfigPredicate, Boolean> predicates, boolean inverted) {
        this.codec = codec;
        this.value = value;
        this.valueID = valueID;
        this.predicates = predicates;
        this.inverted = inverted;
    }

    public ConfigValueCondition(MapCodec<ConfigValueCondition> codec, String valueID, Map<IConfigPredicate, Boolean> predicates, boolean inverted) {
        this(codec, null, valueID, predicates, inverted);
    }

    public ConfigValueCondition(MapCodec<ConfigValueCondition> codec, String valueID, boolean inverted) {
        this(codec, valueID, Maps.newHashMap(), inverted);
    }

    public ConfigValueCondition(MapCodec<ConfigValueCondition> codec, String valueID) {
        this(codec, valueID, false);
    }

    public MapCodec<? extends ICondition> codec() {
        return this.codec;
    }

    public boolean test(ICondition.IContext context) {
        boolean returnValue;
        Map<IConfigPredicate, Boolean> predicates = this.predicates;
        ModConfigSpec.ConfigValue<?> value = this.value;
        if (predicates.size() > 0) {
            returnValue = predicates.keySet().stream().allMatch(c -> ((Boolean)predicates.get(c)).booleanValue() != c.test(value));
        } else {
            Object object = value.get();
            if (object instanceof Boolean) {
                Boolean bool = (Boolean)object;
                returnValue = bool;
            } else {
                throw new IllegalStateException("Predicates required for non-boolean ConfigLootCondition, but none found");
            }
        }
        return this.inverted != returnValue;
    }

    public static class Serializer
    extends MapCodec<ConfigValueCondition> {
        public static final HashMap<ResourceLocation, IConfigPredicateSerializer<?>> CONFIG_PREDICATE_SERIALIZERS = new HashMap();
        private final Map<String, ModConfigSpec.ConfigValue<?>> configValues;

        public Serializer(Map<String, ModConfigSpec.ConfigValue<?>> configValues) {
            this.configValues = configValues;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString("value"), ops.createString("predicates"), ops.createString("inverted"));
        }

        public <T> DataResult<ConfigValueCondition> decode(DynamicOps<T> ops, MapLike<T> input) {
            JsonElement element = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, ops.createMap(input.entries()));
            if (!(element instanceof JsonObject)) {
                return DataResult.error(() -> "Expected an object");
            }
            JsonObject json = (JsonObject)element;
            if (!json.has("value")) {
                return DataResult.error(() -> "Missing 'value', expected to find a string");
            }
            String name = GsonHelper.getAsString((JsonObject)json, (String)"value");
            ModConfigSpec.ConfigValue<?> configValue = this.configValues.get(name);
            if (configValue == null) {
                return DataResult.error(() -> "No config value of name '" + name + "' found");
            }
            HashMap<IConfigPredicate, Boolean> predicates = new HashMap<IConfigPredicate, Boolean>();
            if (GsonHelper.isValidNode((JsonObject)json, (String)"predicates")) {
                for (JsonElement predicateElement : GsonHelper.getAsJsonArray((JsonObject)json, (String)"predicates")) {
                    if (!predicateElement.isJsonObject()) {
                        return DataResult.error(() -> "Predicates must be an array of JsonObjects");
                    }
                    JsonObject predicateObject = predicateElement.getAsJsonObject();
                    ResourceLocation type = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)predicateObject, (String)"type"));
                    IConfigPredicateSerializer<?> serializer = CONFIG_PREDICATE_SERIALIZERS.get(type);
                    if (serializer == null) {
                        return DataResult.error(() -> "Unknown predicate type: " + String.valueOf(type));
                    }
                    predicates.put((IConfigPredicate)serializer.read(predicateObject), predicateObject.has("inverted") && GsonHelper.getAsBoolean((JsonObject)predicateObject, (String)"inverted"));
                }
            } else if (!(configValue.get() instanceof Boolean)) {
                return DataResult.error(() -> "Missing 'predicates' for non-boolean config value '" + name + "', expected to find an array");
            }
            return DataResult.success((Object)new ConfigValueCondition(this, configValue, name, predicates, json.has("inverted") && GsonHelper.getAsBoolean((JsonObject)json, (String)"inverted")));
        }

        public <T> RecordBuilder<T> encode(ConfigValueCondition input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            prefix.add("value", ops.createString(input.valueID));
            if (!input.predicates.isEmpty()) {
                JsonArray predicates = new JsonArray();
                for (Map.Entry<IConfigPredicate, Boolean> predicatePair : input.predicates.entrySet()) {
                    IConfigPredicate predicate = predicatePair.getKey();
                    ResourceLocation predicateID = predicate.getID();
                    JsonObject object = new JsonObject();
                    predicates.add((JsonElement)object);
                    object.addProperty("type", predicateID.toString());
                    CONFIG_PREDICATE_SERIALIZERS.get(predicateID).write(object, predicate);
                    object.addProperty("inverted", predicatePair.getValue());
                }
                prefix.add("predicates", JsonOps.INSTANCE.convertTo(ops, (JsonElement)predicates));
            }
            if (input.inverted) {
                prefix.add("inverted", ops.createBoolean(true));
            }
            return prefix;
        }
    }
}

