/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.storage;

import com.teamabnormals.blueprint.common.world.storage.GlobalStorage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public final class GlobalStorageManager
extends SavedData {
    private static final GlobalStorageManager INSTANCE = new GlobalStorageManager();
    private static final String KEY = "blueprint_storage";
    private static boolean loaded = false;

    private GlobalStorageManager() {
    }

    public static GlobalStorageManager getOrCreate(ServerLevel world) {
        return (GlobalStorageManager)world.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> INSTANCE, (compound, provider) -> {
            loaded = true;
            ListTag storageTags = compound.getList("storages", 10);
            for (int i = 0; i < storageTags.size(); ++i) {
                CompoundTag storageTag = storageTags.getCompound(i);
                GlobalStorage storage = GlobalStorage.STORAGES.get(ResourceLocation.parse((String)storageTag.getString("id")));
                if (storage == null) continue;
                storage.fromTag(storageTag, (HolderLookup.Provider)provider);
            }
            return INSTANCE;
        }), KEY);
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag storageList = new ListTag();
        GlobalStorage.STORAGES.forEach((key, value) -> {
            CompoundTag storageTag = value.createTag(provider);
            storageTag.putString("id", key.toString());
            storageList.add((Object)storageTag);
        });
        compound.put("storages", (Tag)storageList);
        return compound;
    }

    public boolean isDirty() {
        return true;
    }
}

