/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.teamabnormals.blueprint.common.remolder.data.DataType;
import com.teamabnormals.blueprint.common.remolder.data.DataVisitor;
import com.teamabnormals.blueprint.common.remolder.data.ElementType;
import com.teamabnormals.blueprint.common.remolder.data.Molding;
import com.teamabnormals.blueprint.common.remolder.data.ReturnType;

public interface VariableDataVisitor
extends DataVisitor {
    public static final Local OPS = new Local("ops", DataType.REMOLDING);
    public static final Local THIS = new Local("this", DataType.REMOLDING);
    public static final Local ROOT = new Local("root", ElementType.ELEMENTAL);
    public static final Local META = new Local("meta", ElementType.ELEMENTAL);

    public void set(Molding var1);

    public record Local(String name, ReturnType type) implements VariableDataVisitor
    {
        public void allocate(Molding molding) {
            molding.localVarIndex(this.name, this.type.getDataType(molding));
        }

        @Override
        public void visit(Molding molding) {
            DataType<?> type = this.type.getDataType(molding);
            molding.visitVarInsn(type.getType().getOpcode(21), molding.localVarIndex(this.name, type));
        }

        @Override
        public void set(Molding molding) {
            DataType<?> type = this.type.getDataType(molding);
            molding.visitVarInsn(type.getType().getOpcode(54), molding.localVarIndex(this.name, type));
        }

        @Override
        public ReturnType getReturnType() {
            return this.type;
        }
    }

    public record Provided<T>(String name, DataType<T> type, T initial) implements VariableDataVisitor
    {
        @Override
        public void visit(Molding molding) {
            molding.getFieldOwnerVariable().visit(molding);
            molding.visitFieldInsn(180, molding.getFieldOwnerTypeName(), this.name, this.type.getType().getDescriptor());
        }

        @Override
        public void set(Molding molding) {
            molding.getFieldOwnerVariable().visit(molding);
            molding.visitFieldInsn(181, molding.getFieldOwnerTypeName(), this.name, this.type.getType().getDescriptor());
        }

        @Override
        public DataType<?> getReturnType() {
            return this.type;
        }
    }
}

