/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.advancement.modification.modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierSerializers;
import com.teamabnormals.blueprint.common.advancement.modification.BlueprintAdvancementBuilder;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.AdvancementModifier;
import java.util.Optional;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record DisplayInfoModifier(boolean replaces, Optional<ItemStack> icon, Optional<Component> title, Optional<Component> description, Optional<ResourceLocation> background, Optional<AdvancementType> type, Optional<Boolean> showToast, Optional<Boolean> announceToChat, Optional<Boolean> hidden) implements AdvancementModifier<DisplayInfoModifier>
{
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void modify(BlueprintAdvancementBuilder builder) {
        Optional<DisplayInfo> display = builder.display;
        if (display.isPresent() && !this.replaces) {
            DisplayInfo displayInfo = display.get();
            Component title = this.title.orElse(displayInfo.getTitle());
            Component description = this.description.orElse(displayInfo.getDescription());
            ItemStack icon = this.icon.orElse(displayInfo.getIcon());
            Optional prevBackground = displayInfo.getBackground();
            Optional<ResourceLocation> background = prevBackground.isPresent() ? Optional.of(this.background.orElse((ResourceLocation)prevBackground.get())) : this.background;
            AdvancementType advancementType = this.type.orElse(displayInfo.getType());
            boolean showToast = this.showToast.orElse(displayInfo.shouldShowToast());
            boolean announceToChat = this.announceToChat.orElse(displayInfo.shouldAnnounceChat());
            boolean hidden = this.hidden.orElse(displayInfo.isHidden());
            builder.display(new DisplayInfo(icon, title, description, background, advancementType, showToast, announceToChat, hidden));
        } else {
            builder.display(new DisplayInfo(this.icon.orElse(ItemStack.EMPTY), this.title.orElse((Component)Component.empty()), this.description.orElse((Component)Component.empty()), this.background, this.type.orElse(AdvancementType.TASK), this.showToast.orElse(true).booleanValue(), this.announceToChat.orElse(true).booleanValue(), this.hidden.orElse(false).booleanValue()));
        }
    }

    public Serializer getSerializer() {
        return AdvancementModifierSerializers.DISPLAY_INFO;
    }

    public static final class Builder {
        private boolean replace;
        private Optional<Component> title = Optional.empty();
        private Optional<Component> description = Optional.empty();
        private Optional<ItemStack> icon = Optional.empty();
        private Optional<ResourceLocation> background = Optional.empty();
        private Optional<AdvancementType> type = Optional.empty();
        private Optional<Boolean> showToast = Optional.empty();
        private Optional<Boolean> announceToChat = Optional.empty();
        private Optional<Boolean> hidden = Optional.empty();

        private Builder() {
        }

        public Builder replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public Builder title(Component title) {
            this.title = Optional.of(title);
            return this;
        }

        public Builder description(Component description) {
            this.description = Optional.of(description);
            return this;
        }

        public Builder icon(ItemStack icon) {
            this.icon = Optional.of(icon);
            return this;
        }

        public Builder background(ResourceLocation background) {
            this.background = Optional.of(background);
            return this;
        }

        public Builder type(AdvancementType type) {
            this.type = Optional.of(type);
            return this;
        }

        public Builder showToast(boolean showToast) {
            this.showToast = Optional.of(showToast);
            return this;
        }

        public Builder announceToChat(boolean announceToChat) {
            this.announceToChat = Optional.of(announceToChat);
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hidden = Optional.of(hidden);
            return this;
        }

        public DisplayInfoModifier build() {
            return new DisplayInfoModifier(this.replace, this.icon, this.title, this.description, this.background, this.type, this.showToast, this.announceToChat, this.hidden);
        }
    }

    public static final class Serializer
    implements AdvancementModifier.Serializer<DisplayInfoModifier> {
        private static final Codec<DisplayInfoModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("replaces", (Object)false).forGetter(DisplayInfoModifier::replaces), (App)ItemStack.STRICT_CODEC.optionalFieldOf("icon").forGetter(DisplayInfoModifier::icon), (App)ComponentSerialization.CODEC.optionalFieldOf("title").forGetter(DisplayInfoModifier::title), (App)ComponentSerialization.CODEC.optionalFieldOf("description").forGetter(DisplayInfoModifier::description), (App)ResourceLocation.CODEC.optionalFieldOf("background").forGetter(DisplayInfoModifier::background), (App)AdvancementType.CODEC.optionalFieldOf("frame").forGetter(DisplayInfoModifier::type), (App)Codec.BOOL.optionalFieldOf("show_toast").forGetter(DisplayInfoModifier::showToast), (App)Codec.BOOL.optionalFieldOf("announce_to_chat").forGetter(DisplayInfoModifier::announceToChat), (App)Codec.BOOL.optionalFieldOf("hidden").forGetter(DisplayInfoModifier::hidden)).apply((Applicative)instance, DisplayInfoModifier::new));

        @Override
        public JsonElement serialize(DisplayInfoModifier modifier, RegistryOps<JsonElement> ops) throws JsonParseException {
            DataResult result = CODEC.encodeStart(ops, (Object)modifier);
            Optional error = result.error();
            if (error.isPresent()) {
                throw new JsonParseException(((DataResult.Error)error.get()).message());
            }
            return (JsonElement)result.result().get();
        }

        @Override
        public DisplayInfoModifier deserialize(JsonElement element, RegistryOps<JsonElement> ops) throws JsonParseException {
            DataResult result = CODEC.decode(ops, (Object)element);
            Optional error = result.error();
            if (error.isPresent()) {
                throw new JsonParseException(((DataResult.Error)error.get()).message());
            }
            return (DisplayInfoModifier)((Pair)result.result().get()).getFirst();
        }
    }
}

