/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.screen;

import com.teamabnormals.blueprint.client.RewardHandler;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;

public class SlabfishHatScreen
extends Screen {
    public static final String SLABFISH_SCREEN_KEY = "blueprint.screen.slabfish_settings";
    private final Screen parent;

    public SlabfishHatScreen(Screen parent) {
        super((Component)Component.translatable((String)"blueprint.screen.slabfish_settings.title"));
        this.parent = parent;
    }

    protected void init() {
        int i = 0;
        for (RewardHandler.SlabfishSetting setting : RewardHandler.SlabfishSetting.values()) {
            ModConfigSpec.ConfigValue<Boolean> configValue = setting.getConfigValue();
            Button settingButton = Button.builder((Component)this.getOptionName(setting, (Boolean)configValue.get()), button -> {
                boolean enabled = (Boolean)configValue.get() == false;
                configValue.set((Object)enabled);
                button.setMessage(this.getOptionName(setting, enabled));
                NetworkUtil.updateSlabfish(RewardHandler.SlabfishSetting.getConfig());
            }).bounds(this.width / 2 - 155 + i % 2 * 160, this.height / 6 + 24 * (i >> 1), 150, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("blueprint.config.slabfish_hat." + setting.name().toLowerCase(Locale.ROOT) + ".tooltip")))).build();
            this.addRenderableWidget((GuiEventListener)settingButton);
            ++i;
        }
        if (i % 2 == 1) {
            ++i;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.getMinecraft().setScreen(this.parent)).bounds(this.width / 2 - 100, this.height / 6 + 24 * (i >> 1), 200, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        this.getMinecraft().setScreen(this.parent);
    }

    private Component getOptionName(RewardHandler.SlabfishSetting setting, boolean enabled) {
        return CommonComponents.optionStatus((Component)Component.translatable((String)("blueprint.config.slabfish_hat." + setting.name().toLowerCase(Locale.ROOT))), (boolean)enabled);
    }
}

