/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin.compat117plus;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={Shulker.class})
public class ShulkerEntityMixin {
    @ModifyReturnValue(method={"makeBoundingBox()Lnet/minecraft/world/phys/AABB;"}, at={@At(value="RETURN")})
    private AABB pehkui$calculateBoundingBox(AABB box) {
        Shulker entity = (Shulker)this;
        float widthScale = ScaleUtils.getBoundingBoxWidthScale((Entity)entity);
        float heightScale = ScaleUtils.getBoundingBoxHeightScale((Entity)entity);
        if (widthScale != 1.0f || heightScale != 1.0f) {
            Direction facing = entity.getAttachFace().getOpposite();
            double xLength = box.getXsize() / -2.0;
            double yLength = box.getYsize() / -2.0;
            double zLength = box.getZsize() / -2.0;
            double dX = xLength * (1.0 - (double)widthScale);
            double dY = yLength * (1.0 - (double)heightScale);
            double dZ = zLength * (1.0 - (double)widthScale);
            box = box.inflate(dX, dY, dZ);
            box = box.move(dX * (double)facing.getStepX(), dY * (double)facing.getStepY(), dZ * (double)facing.getStepZ());
        }
        return box;
    }
}

