/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class BjornLibUtil {
    public static void renderHull(Vec3 from, Vec3 to, float w, float h, PoseStack poseStack, VertexConsumer vertexConsumer, int r, int g, int b, int a) {
        BjornLibUtil.renderQuad(from.subtract(0.0, (double)(h * 0.5f), 0.0), to.subtract(0.0, (double)(h * 0.5f), 0.0), w, 0.0f, poseStack, vertexConsumer, r, g, b, a);
        BjornLibUtil.renderQuad(from.add(0.0, (double)(h * 0.5f), 0.0), to.add(0.0, (double)(h * 0.5f), 0.0), w, 0.0f, poseStack, vertexConsumer, r, g, b, a);
        BjornLibUtil.renderQuad(from.subtract((double)(w * 0.5f), 0.0, 0.0), to.subtract((double)(w * 0.5f), 0.0, 0.0), 0.0f, h, poseStack, vertexConsumer, r, g, b, a);
        BjornLibUtil.renderQuad(from.add((double)(w * 0.5f), 0.0, 0.0), to.add((double)(w * 0.5f), 0.0, 0.0), 0.0f, h, poseStack, vertexConsumer, r, g, b, a);
    }

    private static void renderQuad(Vec3 from, Vec3 to, float w, float h, PoseStack poseStack, VertexConsumer vertexConsumer, int r, int g, int b, int a) {
        Matrix4f matrix = poseStack.last().pose();
        vertexConsumer.addVertex(matrix, (float)from.x - w * 0.5f, (float)from.y - h * 0.5f, (float)from.z).setColor(r, g, b, a).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(255).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(matrix, (float)from.x + w * 0.5f, (float)from.y + h * 0.5f, (float)from.z).setColor(r, g, b, a).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(255).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(matrix, (float)to.x + w * 0.5f, (float)to.y + h * 0.5f, (float)to.z).setColor(r, g, b, a).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(255).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        vertexConsumer.addVertex(matrix, (float)to.x - w * 0.5f, (float)to.y - h * 0.5f, (float)to.z).setColor(r, g, b, a).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(255).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
    }

    public static Player getNearestPlayer(Vec3 position, ServerLevel serverLevel) {
        return serverLevel.getNearestPlayer(position.x, position.y, position.z, -1.0, false);
    }

    public static boolean probably(double percentage) {
        double zeroToOne = Math.random();
        double multiple = zeroToOne * 100.0;
        return multiple < percentage;
    }

    public static double percentValue(double percent, float value) {
        return percent * (double)value / 100.0;
    }

    public static double fractionOfValue(float value, int maxValue) {
        if (value == 0.0f) {
            return 0.0;
        }
        double fraction = (double)value / (double)maxValue;
        return Mth.clamp((double)fraction, (double)0.0, (double)1.0);
    }

    public static Vec3 randomOffset(float xRange, float yRange, float zRange) {
        double x = Math.random() * 2.0 * (double)xRange - (double)xRange;
        double y = Math.random() * 2.0 * (double)yRange - (double)yRange;
        double z = Math.random() * 2.0 * (double)zRange - (double)zRange;
        return new Vec3(x, y, z);
    }

    public static Optional<Entity> getTargetedEntity(@Nullable Entity entity, int distance, double offset) {
        int i;
        Predicate<Entity> predicate;
        AABB aabb;
        Vec3 vec31;
        Vec3 vec32;
        if (entity == null) {
            return Optional.empty();
        }
        Vec3 vec3 = entity.getEyePosition();
        EntityHitResult entityhitresult = BjornLibUtil.getEntityHitResult(entity, vec3, vec32 = vec3.add(vec31 = entity.getViewVector(1.0f).scale((double)distance)), aabb = entity.getBoundingBox().expandTowards(vec31).inflate(1.0), predicate = p_113447_ -> !p_113447_.isSpectator() && p_113447_.isPickable(), i = distance * distance, offset);
        if (entityhitresult == null) {
            return Optional.empty();
        }
        return vec3.distanceToSqr(entityhitresult.getLocation()) > (double)i ? Optional.empty() : Optional.of(entityhitresult.getEntity());
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Entity p_37288_, Vec3 p_37289_, Vec3 p_37290_, AABB p_37291_, Predicate<Entity> p_37292_, double p_37293_, double offset) {
        Level level = p_37288_.level();
        double d0 = p_37293_;
        Entity entity = null;
        Vec3 vec3 = null;
        for (Entity entity1 : level.getEntities(p_37288_, p_37291_, p_37292_)) {
            Vec3 vec31;
            double d1;
            AABB aabb = entity1.getBoundingBox().inflate(offset);
            Optional optional = aabb.clip(p_37289_, p_37290_);
            if (aabb.contains(p_37289_)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vec3 = optional.orElse(p_37289_);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = p_37289_.distanceToSqr(vec31 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.getRootVehicle() == p_37288_.getRootVehicle()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vec3 = vec31;
                continue;
            }
            entity = entity1;
            vec3 = vec31;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vec3);
    }

    public static BlockHitResult getBlockHitResult(Level level, Entity entity, double distance, ClipContext.Block clipContextBlock) {
        float f = entity.getXRot();
        float f1 = entity.getYRot();
        Vec3 vec3 = entity.getEyePosition();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vec31 = vec3.add((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        return level.clip(new ClipContext(vec3, vec31, clipContextBlock, ClipContext.Fluid.NONE, entity));
    }

    public static void removeItemsFromInventory(Player player, ItemStack itemToRemove, int amount) {
        int remainingAmount = amount;
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            ItemStack stackInSlot = player.getInventory().getItem(slot);
            if (stackInSlot.isEmpty() || !stackInSlot.is(itemToRemove.getItem())) continue;
            int stackCount = stackInSlot.getCount();
            if (stackCount >= remainingAmount) {
                stackInSlot.shrink(remainingAmount);
                return;
            }
            player.getInventory().setItem(slot, ItemStack.EMPTY);
            remainingAmount -= stackCount;
        }
    }

    public static boolean randomTeleport(ServerLevel level, LivingEntity entity, BlockPos tpAround, double distance) {
        return BjornLibUtil.randomTeleport(level, entity, tpAround, distance, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    public static boolean randomTeleport(ServerLevel level, LivingEntity entity, BlockPos tpAround, double distance, Heightmap.Types heightmap) {
        if (!entity.level().isClientSide() && entity.isAlive()) {
            double x = (double)tpAround.getX() + (entity.getRandom().nextDouble() - entity.getRandom().nextDouble()) * distance + 0.5;
            double z = (double)tpAround.getZ() + (entity.getRandom().nextDouble() - entity.getRandom().nextDouble()) * distance + 0.5;
            BlockPos.MutableBlockPos mutableBlockPos = BlockPos.containing((double)x, (double)0.0, (double)z).mutable();
            mutableBlockPos.setY(level.getHeightmapPos(heightmap, (BlockPos)mutableBlockPos).getY());
            return BjornLibUtil.teleport(level, entity, (BlockPos)mutableBlockPos);
        }
        return false;
    }

    public static boolean randomTeleport(ServerLevel level, LivingEntity entity, LivingEntity tpAround, double distance) {
        return BjornLibUtil.randomTeleport(level, entity, tpAround, distance, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    public static boolean randomTeleport(ServerLevel level, LivingEntity entity, LivingEntity tpAround, double distance, Heightmap.Types heightmap) {
        if (!entity.level().isClientSide() && entity.isAlive()) {
            double x = tpAround.getX() + (entity.getRandom().nextDouble() - entity.getRandom().nextDouble()) * distance + 0.5;
            double z = tpAround.getZ() + (entity.getRandom().nextDouble() - entity.getRandom().nextDouble()) * distance + 0.5;
            BlockPos.MutableBlockPos mutableBlockPos = BlockPos.containing((double)x, (double)0.0, (double)z).mutable();
            mutableBlockPos.setY(level.getHeightmapPos(heightmap, (BlockPos)mutableBlockPos).getY());
            return BjornLibUtil.teleport(level, entity, (BlockPos)mutableBlockPos);
        }
        return false;
    }

    public static boolean teleport(ServerLevel level, LivingEntity entity, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)level, (BlockPos)pos, (BlockState)blockstate, (FluidState)blockstate.getFluidState(), (EntityType)entity.getType())) {
            return false;
        }
        if (!level.noCollision(entity.getType().getSpawnAABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()))) {
            return false;
        }
        entity.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        return true;
    }
}

