/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.util;

import com.furiusmax.bjornlib.client.screen.AbilitySlot;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.joml.Vector2f;

public class BjornLibGuiUtil {
    public static void drawLine(GuiGraphics graphics, float startX, float startY, float endX, float endY, float thickness, int argb) {
        Vector2f side = new Vector2f(endX, endY).sub(startX, startY).normalize().perpendicular().mul(thickness / 2.0f);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.addVertex(graphics.pose().last().pose(), startX + side.x, startY + side.y, 0.0f).setColor(argb);
        bufferBuilder.addVertex(graphics.pose().last().pose(), startX - side.x, startY - side.y, 0.0f).setColor(argb);
        bufferBuilder.addVertex(graphics.pose().last().pose(), endX - side.x, endY - side.y, 0.0f).setColor(argb);
        bufferBuilder.addVertex(graphics.pose().last().pose(), endX + side.x, endY + side.y, 0.0f).setColor(argb);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
    }

    public static boolean isMouseBetween(double mouseX, double mouseY, int x, int y, int width, int height) {
        int xSize = x + width;
        int ySize = y + height;
        return mouseX >= (double)x && mouseX <= (double)xSize && mouseY >= (double)y && mouseY <= (double)ySize;
    }

    private static List<FormattedText> prepareForLongText(FormattedText text, int lineWidth, int firstHeight, int subsequentHeight) {
        Font fontRenderer = Minecraft.getInstance().font;
        Objects.requireNonNull(fontRenderer);
        int firstCount = firstHeight / 9;
        Objects.requireNonNull(fontRenderer);
        int count = subsequentHeight / 9;
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>(fontRenderer.getSplitter().splitLines(text, lineWidth, Style.EMPTY));
        ArrayList<FormattedText> pages = new ArrayList<FormattedText>();
        ArrayList<FormattedText> pageLines = lines.size() > firstCount ? lines.subList(0, firstCount) : lines;
        pages.add(BjornLibGuiUtil.combineWithNewLine(pageLines));
        pageLines.clear();
        while (lines.size() > 0) {
            pageLines = lines.size() > count ? lines.subList(0, count) : lines;
            pages.add(BjornLibGuiUtil.combineWithNewLine(pageLines));
            pageLines.clear();
        }
        return pages;
    }

    private static FormattedText combineWithNewLine(List<FormattedText> elements) {
        MutableComponent newLine = Component.literal((String)"\n");
        ArrayList<Object> copy = new ArrayList<Object>(elements.size() * 2);
        for (int i = 0; i < elements.size() - 1; ++i) {
            copy.add(elements.get(i));
            copy.add(newLine);
        }
        copy.add(elements.get(elements.size() - 1));
        return FormattedText.composite(copy);
    }

    public static boolean isMouseOverAbilitySlot(double mouseX, double mouseY, AbilitySlot slot, int sizeX, int sizeY) {
        return mouseX >= (double)slot.x && mouseY >= (double)slot.y && mouseX < (double)(slot.x + sizeX) && mouseY < (double)(slot.y + sizeY);
    }
}

