/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.structures;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class VillageStructure {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty"));

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder.Reference emptyProcessorList = processorListRegistry.getHolderOrThrow(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.legacy((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }

    public static void registerAllVillagesStructure(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, String pieceNBTLocation, int weight) {
        VillageStructure.addBuildingToPool(templatePoolRegistry, processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/plains/houses"), pieceNBTLocation, weight);
        VillageStructure.addBuildingToPool(templatePoolRegistry, processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/taiga/houses"), pieceNBTLocation, weight);
        VillageStructure.addBuildingToPool(templatePoolRegistry, processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/snowy/houses"), pieceNBTLocation, weight);
        VillageStructure.addBuildingToPool(templatePoolRegistry, processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/savanna/houses"), pieceNBTLocation, weight);
        VillageStructure.addBuildingToPool(templatePoolRegistry, processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/desert/houses"), pieceNBTLocation, weight);
    }

    public static void registerPlainsVillageStructure(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, String pieceNBTLocation, int weight) {
        VillageStructure.addBuildingToPool(templatePoolRegistry, processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/plains/houses"), pieceNBTLocation, weight);
    }

    public static void registerTaigaVillageStructure(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, String pieceNBTLocation, int weight) {
        VillageStructure.addBuildingToPool(templatePoolRegistry, processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/taiga/houses"), pieceNBTLocation, weight);
    }

    public static void registerSnowyVillageStructure(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, String pieceNBTLocation, int weight) {
        VillageStructure.addBuildingToPool(templatePoolRegistry, processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/snowy/houses"), pieceNBTLocation, weight);
    }

    public static void registerSavannaVillageStructure(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, String pieceNBTLocation, int weight) {
        VillageStructure.addBuildingToPool(templatePoolRegistry, processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/savanna/houses"), pieceNBTLocation, weight);
    }

    public static void registerDesertVillageStructure(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, String pieceNBTLocation, int weight) {
        VillageStructure.addBuildingToPool(templatePoolRegistry, processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/desert/houses"), pieceNBTLocation, weight);
    }
}

