/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.structures;

import com.furiusmax.bjornlib.structures.ComplexStructure;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class ComplexStructureManager {
    public static Map<ResourceLocation, ComplexStructure> LOADED = new HashMap<ResourceLocation, ComplexStructure>();

    public static boolean isValidNameSpace(String namespace) {
        return LOADED.keySet().stream().anyMatch(resourceLocation -> resourceLocation.getNamespace().equals(namespace));
    }

    public static List<ComplexStructure> getAllFromNameSpace(String namespace) {
        return LOADED.entrySet().stream().filter(set -> ((ResourceLocation)set.getKey()).getNamespace().equals(namespace)).map(Map.Entry::getValue).toList();
    }

    public static boolean isCustomStructure(Holder<StructureTemplatePool> startPool) {
        return LOADED.values().stream().anyMatch(complexStructure -> startPool.is(complexStructure.startingPool));
    }

    public static Optional<ComplexStructure> getCustomStructure(Holder<StructureTemplatePool> startPool) {
        return LOADED.values().stream().filter(complexStructure -> startPool.is(complexStructure.startingPool)).findFirst();
    }
}

