/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ComplexStructure {
    public static final Codec<ComplexStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("startingPool").forGetter(c -> c.startingPool), (App)Codec.INT.fieldOf("minPieces").forGetter(c -> c.minPieces), (App)Codec.INT.fieldOf("maxTries").forGetter(c -> c.maxTries), (App)Codec.BOOL.fieldOf("stopAfterMaxTry").forGetter(c -> c.stopAfterMaxTry), (App)InjectedPiece.CODEC.listOf().optionalFieldOf("injectedPieces").forGetter(c -> c.injectedPieces)).apply((Applicative)instance, ComplexStructure::new));
    ResourceLocation startingPool;
    int minPieces;
    int maxTries;
    boolean stopAfterMaxTry;
    Optional<List<InjectedPiece>> injectedPieces;

    public int getMaxTries() {
        return this.maxTries;
    }

    public int getMinPieces() {
        return this.minPieces;
    }

    public boolean stopAfterMaxTry() {
        return this.stopAfterMaxTry;
    }

    public Optional<List<InjectedPiece>> getOptionalInjectedPieces() {
        return this.injectedPieces;
    }

    public List<InjectedPiece> getInjectedPieces() {
        return this.injectedPieces.orElseGet(ArrayList::new);
    }

    public Optional<InjectedPiece> getInjectedPieceFromPool(ResourceLocation pool, Set<ResourceLocation> piecesAdded, int piecesCount) {
        return this.getInjectedPieces().stream().filter(injectedPiece -> injectedPiece.piecePoolMatch(pool) && !piecesAdded.contains(injectedPiece.injectedFromPool) && piecesCount > injectedPiece.afterPiece).findFirst();
    }

    public Optional<InjectedPiece> getInjectedPieceFromInjectedPool(ResourceLocation pool) {
        return this.getInjectedPieces().stream().filter(injectedPiece -> injectedPiece.pieceInjectedPoolMatch(pool)).findFirst();
    }

    public boolean anyPiecePoolMatch(ResourceLocation pool) {
        return this.getInjectedPieces().stream().anyMatch(injectedPiece -> injectedPiece.piecePoolMatch(pool));
    }

    public boolean anyInjectedPiecePoolMatch(ResourceLocation pool) {
        return this.getInjectedPieces().stream().anyMatch(injectedPiece -> injectedPiece.pieceInjectedPoolMatch(pool));
    }

    public ComplexStructure(ResourceLocation startingPool, int minPieces, int maxTries, boolean stopAfterMaxTry, Optional<List<InjectedPiece>> injectedPieces) {
        this.startingPool = startingPool;
        this.minPieces = minPieces;
        this.maxTries = maxTries;
        this.stopAfterMaxTry = stopAfterMaxTry;
        this.injectedPieces = injectedPieces;
    }

    public static class InjectedPiece {
        public static final Codec<InjectedPiece> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("injectOnPool").forGetter(c -> c.injectOnPool), (App)ResourceLocation.CODEC.fieldOf("injectedFromPool").forGetter(c -> c.injectedFromPool), (App)Codec.INT.fieldOf("afterPiece").forGetter(c -> c.afterPiece)).apply((Applicative)instance, InjectedPiece::new));
        ResourceLocation injectOnPool;
        ResourceLocation injectedFromPool;
        int afterPiece;

        public InjectedPiece(ResourceLocation injectOnPool, ResourceLocation injectedFromPool, int afterPiece) {
            this.injectOnPool = injectOnPool;
            this.injectedFromPool = injectedFromPool;
            this.afterPiece = afterPiece;
        }

        public int getAfterPiece() {
            return this.afterPiece;
        }

        public boolean piecePoolMatch(ResourceLocation pool) {
            return this.injectOnPool.equals((Object)pool);
        }

        public boolean pieceInjectedPoolMatch(ResourceLocation pool) {
            return this.injectedFromPool.equals((Object)pool);
        }

        public ResourceLocation getInjectedFromPool() {
            return this.injectedFromPool;
        }

        public ResourceLocation getInjectOnPool() {
            return this.injectOnPool;
        }
    }
}

