/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.registry;

import com.furiusmax.bjornlib.quest.rewards.ItemReward;
import com.furiusmax.bjornlib.quest.rewards.Reward;
import com.furiusmax.bjornlib.quest.steps.CollectItemQuestStep;
import com.furiusmax.bjornlib.quest.steps.ConsumeQuestStep;
import com.furiusmax.bjornlib.quest.steps.KillMobQuestStep;
import com.furiusmax.bjornlib.quest.steps.QuestStep;
import com.furiusmax.bjornlib.quest.types.Quest;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class QuestRegistry {
    public static Map<ResourceLocation, Supplier<Quest>> questTypes = new HashMap<ResourceLocation, Supplier<Quest>>();
    private static Map<ResourceLocation, Supplier<QuestStep>> stepTypes = new HashMap<ResourceLocation, Supplier<QuestStep>>();
    private static Map<ResourceLocation, Supplier<Reward>> rewardTypes = new HashMap<ResourceLocation, Supplier<Reward>>();

    public static void registerQuests() {
        QuestRegistry.registerStep(ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"collect_item_step"), CollectItemQuestStep::new);
        QuestRegistry.registerStep(ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"kill_mob_step"), KillMobQuestStep::new);
        QuestRegistry.registerStep(ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"consume_item_step"), ConsumeQuestStep::new);
        QuestRegistry.registerReward(ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"item_reward"), ItemReward::new);
    }

    public static Supplier<Quest> registerQuest(ResourceLocation id, Supplier<Quest> questSupplier) {
        questTypes.put(id, questSupplier);
        return questSupplier;
    }

    public static Supplier<QuestStep> registerStep(ResourceLocation id, Supplier<QuestStep> stepSupplier) {
        Supplier<QuestStep> withId = () -> ((QuestStep)stepSupplier.get()).setId(id);
        stepTypes.put(id, withId);
        return withId;
    }

    public static Supplier<Reward> registerReward(ResourceLocation id, Supplier<Reward> rewardSupplier) {
        if (!rewardTypes.containsKey(id)) {
            Supplier<Reward> withId = () -> ((Reward)rewardSupplier.get()).setId(id);
            rewardTypes.put(id, withId);
            return withId;
        }
        throw new IllegalArgumentException("Reward with ID " + String.valueOf(id) + " is already registered.");
    }

    public static Quest createQuest(ResourceLocation id) {
        Supplier<Quest> questSupplier = questTypes.get(id);
        return questSupplier != null ? questSupplier.get() : null;
    }

    public static QuestStep createStep(ResourceLocation id) {
        Supplier<QuestStep> stepSupplier = stepTypes.get(id);
        return stepSupplier != null ? stepSupplier.get() : null;
    }

    public static Reward createReward(ResourceLocation id) {
        Supplier<Reward> rewardSupplier = rewardTypes.get(id);
        return rewardSupplier != null ? rewardSupplier.get() : null;
    }

    public static MapCodec<? extends Quest> questCodec(ResourceLocation id) {
        Supplier<Quest> stepSupplier = questTypes.get(id);
        return stepSupplier != null ? stepSupplier.get().codec() : null;
    }

    public static MapCodec<? extends QuestStep> stepCodec(ResourceLocation id) {
        Supplier<QuestStep> stepSupplier = stepTypes.get(id);
        return stepSupplier != null ? stepSupplier.get().codec() : null;
    }

    public static MapCodec<? extends Reward> rewardCodec(ResourceLocation id) {
        Supplier<Reward> rewardSupplier = rewardTypes.get(id);
        return rewardSupplier != null ? rewardSupplier.get().codec() : null;
    }
}

