/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.registry;

import com.furiusmax.bjornlib.client.particle.AirParticleType;
import com.furiusmax.bjornlib.client.particle.CloudParticleType;
import com.furiusmax.bjornlib.client.particle.ExplosionParticleType;
import com.furiusmax.bjornlib.client.particle.FlameParticleType;
import com.furiusmax.bjornlib.client.particle.GenericParticleData;
import com.furiusmax.bjornlib.client.particle.HeartParticleType;
import com.furiusmax.bjornlib.client.particle.LightningParticleOptions;
import com.furiusmax.bjornlib.client.particle.LightningParticleType;
import com.furiusmax.bjornlib.client.particle.LineWispParticleType;
import com.furiusmax.bjornlib.client.particle.SmokeParticleType;
import com.furiusmax.bjornlib.client.particle.SparkParticleType;
import com.furiusmax.bjornlib.client.particle.WispParticleType;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;

public class ParticleRegistry {
    public static final ParticleType<GenericParticleData> SPARK_PARTICLE = new SparkParticleType();
    public static final ParticleType<GenericParticleData> WISP_PARTICLE = new WispParticleType();
    public static final ParticleType<GenericParticleData> SMOKE_PARTICLE = new SmokeParticleType();
    public static final ParticleType<GenericParticleData> FLAME_PARTICLE = new FlameParticleType();
    public static final ParticleType<GenericParticleData> AIR_PARTICLE = new AirParticleType();
    public static final ParticleType<GenericParticleData> EXPLOSION_PARTICLE = new ExplosionParticleType();
    public static final ParticleType<GenericParticleData> CLOUD_PARTICLE = new CloudParticleType();
    public static final ParticleType<GenericParticleData> HEART_PARTICLE = new HeartParticleType();
    public static final ParticleType<GenericParticleData> LINE_WISP_PARTICLE = new LineWispParticleType();
    public static final ParticleType<LightningParticleOptions> LIGHTNING_PARTICLE = new LightningParticleType();

    public static void registerParticles(BiConsumer<ParticleType<?>, ResourceLocation> r) {
        r.accept(SPARK_PARTICLE, ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"spark_particle"));
        r.accept(WISP_PARTICLE, ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"wisp_particle"));
        r.accept(SMOKE_PARTICLE, ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"smoke_particle"));
        r.accept(FLAME_PARTICLE, ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"flame_particle"));
        r.accept(AIR_PARTICLE, ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"air_particle"));
        r.accept(EXPLOSION_PARTICLE, ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"explosion_particle"));
        r.accept(CLOUD_PARTICLE, ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"cloud_particle"));
        r.accept(HEART_PARTICLE, ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"heart_particle"));
        r.accept(LINE_WISP_PARTICLE, ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"line_wisp_particle"));
        r.accept(LIGHTNING_PARTICLE, ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"lightning_particle"));
    }

    public static class FactoryHandler {
        public static void registerFactories(Consumer consumer) {
            consumer.register(SPARK_PARTICLE, SparkParticleType.Provider::new);
            consumer.register(WISP_PARTICLE, WispParticleType.Provider::new);
            consumer.register(SMOKE_PARTICLE, SmokeParticleType.Provider::new);
            consumer.register(FLAME_PARTICLE, FlameParticleType.Provider::new);
            consumer.register(AIR_PARTICLE, AirParticleType.Provider::new);
            consumer.register(EXPLOSION_PARTICLE, ExplosionParticleType.Provider::new);
            consumer.register(CLOUD_PARTICLE, CloudParticleType.Provider::new);
            consumer.register(HEART_PARTICLE, HeartParticleType.Provider::new);
            consumer.register(LINE_WISP_PARTICLE, LineWispParticleType.Provider::new);
            consumer.register(LIGHTNING_PARTICLE, LightningParticleType.Provider::new);
        }

        public static interface Consumer {
            public <T extends ParticleOptions> void register(ParticleType<T> var1, Function<SpriteSet, ParticleProvider<T>> var2);
        }
    }
}

