/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.quest.types;

import com.furiusmax.bjornlib.quest.categories.QuestCategory;
import com.furiusmax.bjornlib.quest.rewards.Reward;
import com.furiusmax.bjornlib.quest.steps.QuestStep;
import com.furiusmax.bjornlib.registry.QuestRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class Quest<T> {
    public static final Codec<Quest> CODEC = ResourceLocation.CODEC.dispatch(Quest::getId, QuestRegistry::questCodec);
    public static final Codec<Quest> BASE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("quest_id").forGetter(Quest::getId), (App)Codec.STRING.fieldOf("description").forGetter(Quest::getDescriptionKey), (App)QuestStep.CODEC.listOf().fieldOf("quest_steps").forGetter(Quest::getSteps), (App)Reward.CODEC.listOf().fieldOf("quest_rewards").forGetter(Quest::getRewards), (App)QuestCategory.CODEC.fieldOf("quest_category").forGetter(Quest::getQuestCategory), (App)Codec.BOOL.optionalFieldOf("quest_completed", (Object)false).forGetter(Quest::isQuestCompleted)).apply((Applicative)instance, Quest::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Quest> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Quest::getId, (StreamCodec)ByteBufCodecs.STRING_UTF8, Quest::getDescriptionKey, QuestStep.LIST_CODEC, Quest::getSteps, Reward.LIST_CODEC, Quest::getRewards, QuestCategory.STREAM_CODEC, Quest::getQuestCategory, (StreamCodec)ByteBufCodecs.BOOL, Quest::isQuestCompleted, Quest::new);
    public ResourceLocation id;
    public String descriptionKey;
    protected boolean completed;
    protected List<QuestStep> steps = new ArrayList<QuestStep>();
    protected List<Reward> rewards = new ArrayList<Reward>();
    public QuestCategory questCategory;

    public Quest() {
        this.completed = false;
    }

    public Quest(ResourceLocation id, String descriptionKey, List<QuestStep> steps, List<Reward> rewards, QuestCategory questCategory, boolean completed) {
        this.id = id;
        this.descriptionKey = descriptionKey;
        this.completed = completed;
        this.steps = steps;
        this.rewards = rewards;
        this.questCategory = questCategory;
    }

    public Quest(Quest quest) {
        this.id = quest.id;
        this.descriptionKey = quest.descriptionKey;
        this.completed = quest.completed;
        this.steps = quest.steps;
        this.rewards = quest.rewards;
        this.questCategory = quest.questCategory;
    }

    public void addStep(QuestStep step) {
        this.steps.add(step);
    }

    public boolean isQuestCompleted() {
        return this.completed;
    }

    public QuestCategory getQuestCategory() {
        return this.questCategory;
    }

    public Quest setQuestCategory(QuestCategory questCategory) {
        this.questCategory = questCategory;
        return this;
    }

    public void addReward(Reward reward) {
        this.rewards.add(reward);
    }

    public Quest setId(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<QuestStep> getSteps() {
        return this.steps;
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public Quest setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
        return this;
    }

    public MapCodec<T> codec() {
        return null;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public List<QuestStep> getNextPendingSteps(Player player) {
        return new ArrayList<QuestStep>();
    }

    public boolean isCompleted(Player player) {
        for (QuestStep step : this.steps) {
            if (step.isCompleted()) continue;
            return false;
        }
        this.completed = true;
        return true;
    }

    public void reset() {
        this.completed = false;
        for (QuestStep step : this.steps) {
            step.reset();
        }
    }

    public Component getName() {
        return Component.translatable((String)("quest." + this.id.getNamespace() + "." + this.id.getPath() + ".name"));
    }

    public Component getDescription() {
        return Component.translatable((String)this.descriptionKey);
    }
}

