/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.quest.steps;

import com.furiusmax.bjornlib.registry.QuestRegistry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class QuestStep<S> {
    public static final Codec<QuestStep> CODEC = ResourceLocation.CODEC.dispatch(QuestStep::getId, QuestRegistry::stepCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<QuestStep>> LIST_CODEC = StreamCodec.of((buf, list) -> {
        buf.writeInt(list.size());
        for (QuestStep step : list) {
            step.streamCodec().encode(buf, (Object)step);
        }
    }, buf -> {
        int size = buf.readInt();
        ArrayList<QuestStep> list = new ArrayList<QuestStep>();
        for (int i = 0; i < size; ++i) {
            list.add((QuestStep)((QuestStep)list.get(i)).streamCodec().decode(buf));
        }
        return list;
    });
    ResourceLocation id;
    public String descriptionKey;
    public boolean completed;
    public boolean unlocksNextStep;

    public QuestStep() {
    }

    public QuestStep(String descriptionKey) {
        this.descriptionKey = descriptionKey;
        this.completed = false;
    }

    public QuestStep(String descriptionKey, ResourceLocation id, boolean completed, boolean unlocksNextStep) {
        this.descriptionKey = descriptionKey;
        this.completed = completed;
        this.id = id;
        this.unlocksNextStep = unlocksNextStep;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public QuestStep setId(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public abstract boolean tick(Player var1);

    public void complete() {
        this.completed = true;
    }

    public abstract MapCodec<S> codec();

    public abstract StreamCodec<RegistryFriendlyByteBuf, S> streamCodec();

    public abstract StreamCodec<RegistryFriendlyByteBuf, List<S>> streamListCodec();

    public boolean isCompleted() {
        return this.completed;
    }

    public Component getDescription() {
        return Component.translatable((String)this.descriptionKey);
    }

    public abstract int renderStep(GuiGraphics var1, float var2, float var3, int var4, boolean var5);

    public abstract float renderStepWithMargin(GuiGraphics var1, float var2, float var3, int var4, boolean var5, int var6, float var7);

    public boolean doesUnlockNextStep() {
        return this.unlocksNextStep;
    }

    public void reset() {
        this.completed = false;
    }
}

