/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.quest.steps;

import com.furiusmax.bjornlib.BjornLibStreamCodec;
import com.furiusmax.bjornlib.quest.steps.QuestStep;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ConsumeQuestStep
extends QuestStep<ConsumeQuestStep> {
    public static final MapCodec<ConsumeQuestStep> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(QuestStep::getDescriptionKey), (App)ItemStack.OPTIONAL_CODEC.fieldOf("item").forGetter(ConsumeQuestStep::getItem), (App)Codec.INT.fieldOf("required").forGetter(ConsumeQuestStep::getRequiredAmount), (App)Codec.INT.fieldOf("current").forGetter(ConsumeQuestStep::getCurrentAmount), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(QuestStep::getId), (App)Codec.BOOL.fieldOf("completed").forGetter(QuestStep::isCompleted), (App)Codec.BOOL.fieldOf("unlockNext").forGetter(QuestStep::doesUnlockNextStep)).apply((Applicative)instance, ConsumeQuestStep::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConsumeQuestStep> STREAM_CODEC = BjornLibStreamCodec.composite(ByteBufCodecs.STRING_UTF8, QuestStep::getDescriptionKey, ItemStack.OPTIONAL_STREAM_CODEC, ConsumeQuestStep::getItem, ByteBufCodecs.INT, ConsumeQuestStep::getRequiredAmount, ByteBufCodecs.INT, ConsumeQuestStep::getCurrentAmount, ResourceLocation.STREAM_CODEC, QuestStep::getId, ByteBufCodecs.BOOL, QuestStep::isCompleted, ByteBufCodecs.BOOL, QuestStep::doesUnlockNextStep, ConsumeQuestStep::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ConsumeQuestStep>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    private ItemStack item;
    private int requiredAmount;
    private int currentAmount;

    public ConsumeQuestStep() {
        this.id = ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"consume_item_step");
    }

    public ConsumeQuestStep(String descriptionKey, ItemStack item, int requiredAmount) {
        super(descriptionKey);
        this.id = ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"consume_item_step");
        this.item = item;
        this.requiredAmount = requiredAmount;
    }

    public ConsumeQuestStep(String descriptionKey, ItemStack item, int requiredAmount, int currentAmount, ResourceLocation id, boolean completed, boolean unlocksNextStep) {
        super(descriptionKey, id, completed, unlocksNextStep);
        this.id = id;
        this.item = item;
        this.requiredAmount = requiredAmount;
        this.currentAmount = currentAmount;
    }

    @Override
    public boolean tick(Player player) {
        if (this.currentAmount >= this.requiredAmount) {
            this.complete();
        }
        return this.currentAmount >= this.requiredAmount;
    }

    @Override
    public MapCodec<ConsumeQuestStep> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ConsumeQuestStep> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, List<ConsumeQuestStep>> streamListCodec() {
        return LIST_STREAM_CODEC;
    }

    public void onItemConsumed(Player player, ItemStack item) {
        if (item.is(this.item.getItem())) {
            ++this.currentAmount;
        }
    }

    @Override
    public int renderStep(GuiGraphics guiGraphics, float x, float y, int color, boolean shadow) {
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"step.bjornlib.consume_item_step", (Object[])new Object[]{this.item.getHoverName().getString(), this.currentAmount, this.requiredAmount}), (int)x, (int)y, color, shadow);
        return Minecraft.getInstance().font.width((FormattedText)Component.translatable((String)"step.bjornlib.consume_item_step", (Object[])new Object[]{this.item.getHoverName().getString(), this.currentAmount, this.requiredAmount}));
    }

    @Override
    public float renderStepWithMargin(GuiGraphics guiGraphics, float x, float y, int color, boolean shadow, int border, float scale) {
        guiGraphics.pose().pushPose();
        int wrapWidth = (int)((float)border / scale);
        List cachedPageComponents = Minecraft.getInstance().font.split((FormattedText)Component.translatable((String)"step.bjornlib.consume_item_step", (Object[])new Object[]{this.item.getHoverName().getString(), this.currentAmount, this.requiredAmount}), wrapWidth);
        int k = Math.min(border / 9, cachedPageComponents.size());
        guiGraphics.pose().scale(scale, scale, scale);
        y /= scale;
        for (int i = 0; i < k; ++i) {
            FormattedCharSequence formattedcharsequence = (FormattedCharSequence)cachedPageComponents.get(i);
            guiGraphics.pose().translate(x / scale, y, 0.0f);
            guiGraphics.drawString(Minecraft.getInstance().font, formattedcharsequence, 0, 0, 0, false);
            guiGraphics.pose().translate(-x / scale, -y, 0.0f);
            y += 14.0f * scale;
        }
        guiGraphics.pose().popPose();
        return y;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getRequiredAmount() {
        return this.requiredAmount;
    }

    public ConsumeQuestStep setCurrentAmount(int currentAmount) {
        this.currentAmount = currentAmount;
        return this;
    }

    @Override
    public void reset() {
        super.reset();
        this.currentAmount = 0;
    }

    public int getCurrentAmount() {
        return this.currentAmount;
    }
}

