/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.quest.steps;

import com.furiusmax.bjornlib.BjornLibStreamCodec;
import com.furiusmax.bjornlib.quest.steps.QuestStep;
import com.furiusmax.bjornlib.util.BjornLibUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CollectItemQuestStep
extends QuestStep<CollectItemQuestStep> {
    public static final MapCodec<CollectItemQuestStep> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(QuestStep::getDescriptionKey), (App)ItemStack.CODEC.fieldOf("item").forGetter(CollectItemQuestStep::getItem), (App)Codec.INT.fieldOf("required").forGetter(CollectItemQuestStep::getRequiredAmount), (App)Codec.INT.fieldOf("current").forGetter(CollectItemQuestStep::getCurrentAmount), (App)Codec.BOOL.fieldOf("removeItems").forGetter(CollectItemQuestStep::removeItems), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(QuestStep::getId), (App)Codec.BOOL.fieldOf("completed").forGetter(QuestStep::isCompleted), (App)Codec.BOOL.fieldOf("unlockNext").forGetter(QuestStep::doesUnlockNextStep)).apply((Applicative)instance, CollectItemQuestStep::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CollectItemQuestStep> STREAM_CODEC = BjornLibStreamCodec.composite(ByteBufCodecs.STRING_UTF8, QuestStep::getDescriptionKey, ItemStack.STREAM_CODEC, CollectItemQuestStep::getItem, ByteBufCodecs.INT, CollectItemQuestStep::getRequiredAmount, ByteBufCodecs.INT, CollectItemQuestStep::getCurrentAmount, ByteBufCodecs.BOOL, CollectItemQuestStep::removeItems, ResourceLocation.STREAM_CODEC, QuestStep::getId, ByteBufCodecs.BOOL, QuestStep::isCompleted, ByteBufCodecs.BOOL, QuestStep::doesUnlockNextStep, CollectItemQuestStep::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<CollectItemQuestStep>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    private ItemStack item;
    private int requiredAmount;
    private int currentAmount;
    private boolean removeItems;

    public CollectItemQuestStep() {
        this.id = ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"collect_item_step");
    }

    public CollectItemQuestStep(String descriptionKey, ItemStack item, int requiredAmount) {
        super(descriptionKey);
        this.id = ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"collect_item_step");
        this.item = item;
        this.requiredAmount = requiredAmount;
        this.removeItems = false;
    }

    public CollectItemQuestStep(String descriptionKey, ItemStack item, int requiredAmount, boolean removeItems) {
        super(descriptionKey);
        this.id = ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"collect_item_step");
        this.item = item;
        this.requiredAmount = requiredAmount;
        this.removeItems = removeItems;
    }

    public CollectItemQuestStep(String descriptionKey, ItemStack item, int requiredAmount, int currentAmount, boolean removeItems, ResourceLocation id, boolean completed, boolean unlocksNextStep) {
        super(descriptionKey, id, completed, unlocksNextStep);
        this.id = id;
        this.item = item;
        this.requiredAmount = requiredAmount;
        this.removeItems = removeItems;
    }

    @Override
    public boolean tick(Player player) {
        int collectedAmount = 0;
        for (ItemStack itemStack : player.getInventory().items) {
            if (BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).equals((Object)BuiltInRegistries.ITEM.getKey((Object)this.item.getItem()))) {
                collectedAmount += itemStack.getCount();
            }
            this.currentAmount = collectedAmount;
            if (collectedAmount < this.requiredAmount) continue;
            if (this.removeItems) {
                BjornLibUtil.removeItemsFromInventory(player, this.item, this.requiredAmount);
            }
            this.complete();
            return true;
        }
        return false;
    }

    @Override
    public MapCodec<CollectItemQuestStep> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, CollectItemQuestStep> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, List<CollectItemQuestStep>> streamListCodec() {
        return LIST_STREAM_CODEC;
    }

    @Override
    public int renderStep(GuiGraphics guiGraphics, float x, float y, int color, boolean shadow) {
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"step.bjornlib.collect_item_step", (Object[])new Object[]{this.item.getHoverName().getString(), this.currentAmount, this.requiredAmount}), (int)x, (int)y, color, shadow);
        return Minecraft.getInstance().font.width((FormattedText)Component.translatable((String)"step.bjornlib.collect_item_step", (Object[])new Object[]{this.item.getHoverName().getString(), this.currentAmount, this.requiredAmount}));
    }

    @Override
    public float renderStepWithMargin(GuiGraphics guiGraphics, float x, float y, int color, boolean shadow, int border, float scale) {
        guiGraphics.pose().pushPose();
        int wrapWidth = (int)((float)border / scale);
        List cachedPageComponents = Minecraft.getInstance().font.split((FormattedText)Component.translatable((String)"step.bjornlib.collect_item_step", (Object[])new Object[]{this.item.getHoverName().getString(), this.currentAmount, this.requiredAmount}), wrapWidth);
        int k = Math.min(border / 9, cachedPageComponents.size());
        guiGraphics.pose().scale(scale, scale, scale);
        y /= scale;
        for (int i = 0; i < k; ++i) {
            FormattedCharSequence formattedcharsequence = (FormattedCharSequence)cachedPageComponents.get(i);
            guiGraphics.pose().translate(x / scale, y, 0.0f);
            guiGraphics.drawString(Minecraft.getInstance().font, formattedcharsequence, 0, 0, 0, false);
            guiGraphics.pose().translate(-x / scale, -y, 0.0f);
            y += 14.0f * scale;
        }
        guiGraphics.pose().popPose();
        return y;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getRequiredAmount() {
        return this.requiredAmount;
    }

    public CollectItemQuestStep setCurrentAmount(int currentAmount) {
        this.currentAmount = currentAmount;
        return this;
    }

    public int getCurrentAmount() {
        return this.currentAmount;
    }

    public boolean removeItems() {
        return this.removeItems;
    }

    @Override
    public void reset() {
        super.reset();
        this.currentAmount = 0;
    }
}

