/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.quest.rewards;

import com.furiusmax.bjornlib.registry.QuestRegistry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class Reward<T> {
    public static final Codec<Reward> CODEC = ResourceLocation.CODEC.dispatch(Reward::getId, QuestRegistry::rewardCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<Reward>> LIST_CODEC = StreamCodec.of((buf, list) -> {
        buf.writeInt(list.size());
        for (Reward reward : list) {
            reward.streamCodec().encode(buf, (Object)reward);
        }
    }, buf -> {
        int size = buf.readInt();
        ArrayList<Reward> list = new ArrayList<Reward>();
        for (int i = 0; i < size; ++i) {
            list.add((Reward)((Reward)list.get(i)).streamCodec().decode(buf));
        }
        return list;
    });
    ResourceLocation id;

    public Reward() {
    }

    public Reward(ResourceLocation id) {
        this.id = id;
    }

    public Reward<T> setId(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public abstract MapCodec<T> codec();

    public abstract void rewardPlayer(Player var1);

    public abstract StreamCodec<RegistryFriendlyByteBuf, T> streamCodec();

    public abstract StreamCodec<RegistryFriendlyByteBuf, List<T>> streamListCodec();

    public CompoundTag saveToTag(HolderLookup.Provider registryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putString("RewardType", this.id.toString());
        return tag;
    }

    public void loadFromTag(HolderLookup.Provider registryAccess, CompoundTag tag) {
    }

    public static Reward getFromTag(HolderLookup.Provider registryAccess, CompoundTag tag) {
        ResourceLocation id = ResourceLocation.parse((String)tag.getString("RewardType"));
        Reward reward = QuestRegistry.createReward(id);
        if (reward == null) {
            return null;
        }
        reward.loadFromTag(registryAccess, tag);
        reward.id = id;
        return reward;
    }
}

