/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.quest.rewards;

import com.furiusmax.bjornlib.quest.rewards.Reward;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemReward
extends Reward<ItemReward> {
    private ItemStack item = ItemStack.EMPTY;
    public static final MapCodec<ItemReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("item").forGetter(ItemReward::getItem), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(Reward::getId)).apply((Applicative)instance, ItemReward::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemReward> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ItemReward::getItem, (StreamCodec)ResourceLocation.STREAM_CODEC, Reward::getId, ItemReward::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemReward>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));

    public ItemReward() {
    }

    @Override
    public MapCodec<ItemReward> codec() {
        return CODEC;
    }

    public ItemReward(ItemStack item, ResourceLocation id) {
        super(id);
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public void rewardPlayer(Player player) {
        player.getInventory().add(this.item);
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ItemReward> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, List<ItemReward>> streamListCodec() {
        return LIST_STREAM_CODEC;
    }

    @Override
    public CompoundTag saveToTag(HolderLookup.Provider registryAccess) {
        CompoundTag tag = super.saveToTag(registryAccess);
        tag.put("Item", this.item.saveOptional(registryAccess));
        return tag;
    }

    @Override
    public void loadFromTag(HolderLookup.Provider registryAccess, CompoundTag tag) {
        super.loadFromTag(registryAccess, tag);
        this.item = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)tag.getCompound("Item"));
    }
}

