/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.quest.categories;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class QuestCategory {
    public static QuestCategory MAIN_QUEST = new QuestCategory().setId(ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"main_quest")).setColor(4817111);
    public static QuestCategory SECONDARY_QUEST = new QuestCategory().setId(ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"secondary_quest")).setColor(14800896);
    private ResourceLocation id;
    private ResourceLocation iconTexture = ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"textures/gui/quest/icons/quest_icon.png");
    private int color;
    public static final Codec<QuestCategory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("category_id").forGetter(QuestCategory::getId), (App)ResourceLocation.CODEC.fieldOf("icon_texture").forGetter(QuestCategory::getIconTexture), (App)Codec.INT.fieldOf("color").forGetter(QuestCategory::getColor)).apply((Applicative)instance, QuestCategory::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, QuestCategory> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, QuestCategory::getId, (StreamCodec)ResourceLocation.STREAM_CODEC, QuestCategory::getIconTexture, (StreamCodec)ByteBufCodecs.INT, QuestCategory::getColor, QuestCategory::new);

    private QuestCategory(ResourceLocation id, ResourceLocation iconTexture, int color) {
        this.id = id;
        this.iconTexture = iconTexture;
        this.color = color;
    }

    public QuestCategory() {
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public QuestCategory setColor(int color) {
        this.color = color;
        return this;
    }

    public QuestCategory setIconTexture(ResourceLocation iconTexture) {
        this.iconTexture = iconTexture;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public Component getName() {
        return Component.translatable((String)("category." + this.id.getNamespace() + "." + this.id.getPath() + ".name"));
    }

    public ResourceLocation getIconTexture() {
        return this.iconTexture;
    }

    public QuestCategory setId(ResourceLocation id) {
        this.id = id;
        return this;
    }
}

