/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.quest;

import com.furiusmax.bjornlib.quest.categories.QuestCategory;
import com.furiusmax.bjornlib.quest.rewards.Reward;
import com.furiusmax.bjornlib.quest.steps.QuestStep;
import com.furiusmax.bjornlib.quest.types.Quest;
import com.furiusmax.bjornlib.registry.QuestRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class QuestBuilder {
    private final ResourceLocation id;
    private final Supplier<Quest> questSupplier;
    private final List<Supplier<QuestStep>> steps = new ArrayList<Supplier<QuestStep>>();
    private final List<Supplier<Reward>> rewards = new ArrayList<Supplier<Reward>>();
    private String descriptionKey;
    private QuestCategory questCategory;

    public QuestBuilder(ResourceLocation id, Supplier<Quest> questSupplier) {
        this.id = id;
        this.questSupplier = questSupplier;
    }

    public QuestBuilder setDescription(String descriptionKey) {
        this.descriptionKey = descriptionKey;
        return this;
    }

    public QuestBuilder addStep(Supplier<QuestStep> stepSupplier, boolean unlocksNextStep) {
        QuestStep step = stepSupplier.get();
        step.unlocksNextStep = unlocksNextStep;
        this.steps.add(() -> step);
        return this;
    }

    public QuestBuilder addStep(Supplier<QuestStep> stepSupplier) {
        return this.addStep(stepSupplier, false);
    }

    public QuestBuilder setQuestCategory(QuestCategory questCategory) {
        this.questCategory = questCategory;
        return this;
    }

    public QuestBuilder addReward(Supplier<Reward> rewardSupplier) {
        this.rewards.add(rewardSupplier);
        return this;
    }

    public Quest buildAndRegister() {
        Quest quest = this.questSupplier.get();
        quest.id = this.id;
        quest.descriptionKey = this.descriptionKey;
        quest.questCategory = this.questCategory;
        for (Supplier<QuestStep> supplier : this.steps) {
            quest.addStep(supplier.get());
        }
        for (Supplier<Object> supplier : this.rewards) {
            quest.addReward((Reward)supplier.get());
        }
        QuestRegistry.registerQuest(this.id, () -> quest);
        return quest;
    }
}

