/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.neo.util;

import com.furiusmax.bjornlib.neo.mixin.client.PlayerRendererInvoker;
import com.furiusmax.bjornlib.util.BjornLibUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BjornLibNeoUtil
extends BjornLibUtil {
    @OnlyIn(value=Dist.CLIENT)
    public static Vec3 getInWorldPosition(ModelPart modelPart, Vector3f offset, HumanoidModel<?> model, AbstractClientPlayer player, float partialTicks) {
        Vector3f vec = new Vector3f(0.0f, 0.0f, 0.0f);
        vec = BjornLibNeoUtil.getTransformationMatrix(modelPart, offset, model, player, partialTicks).transformPosition(vec);
        return player.getPosition(partialTicks).add((double)vec.x, (double)vec.y, (double)vec.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Matrix4f getTransformationMatrix(ModelPart modelPart, Vector3f offset, HumanoidModel<?> model, AbstractClientPlayer player, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        if (modelPart == null) {
            return poseStack.last().pose();
        }
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player);
        if (renderer instanceof PlayerRendererInvoker) {
            Entity entity;
            PlayerRendererInvoker invoker = (PlayerRendererInvoker)renderer;
            float f = Mth.rotLerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot);
            float g = Mth.rotLerp((float)partialTicks, (float)player.yHeadRotO, (float)player.yHeadRot);
            if (player.isPassenger() && (entity = player.getVehicle()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = Mth.rotLerp((float)partialTicks, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
                float h = g - f;
                float i = Mth.wrapDegrees((float)h);
                if (i < -85.0f) {
                    i = -85.0f;
                }
                if (i >= 85.0f) {
                    i = 85.0f;
                }
                f = g - i;
                if (i * i > 2500.0f) {
                    f += i * 0.2f;
                }
            }
            invoker.invokeSetupRotations(player, poseStack, (float)player.tickCount + partialTicks, f, partialTicks, player.getScale());
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            invoker.invokeScale(player, poseStack, partialTicks);
            poseStack.translate(0.0f, -1.501f, 0.0f);
            modelPart.translateAndRotate(poseStack);
            poseStack.translate(offset.x, offset.y, offset.z);
        }
        return poseStack.last().pose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void shakeCamera(ViewportEvent.ComputeCameraAngles event) {
        if (Math.random() < 0.5) {
            event.setPitch((float)((double)event.getPitch() + Math.random() * 2.0));
            event.setRoll((float)((double)event.getRoll() + Math.random() * 2.0));
            event.setYaw((float)((double)event.getYaw() + Math.random() * 2.0));
        } else {
            event.setPitch((float)((double)event.getPitch() - Math.random() * 2.0));
            event.setRoll((float)((double)event.getRoll() - Math.random() * 2.0));
            event.setYaw((float)((double)event.getYaw() - Math.random() * 2.0));
        }
    }
}

