/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.neo.structure;

import com.furiusmax.bjornlib.BjornLib;
import com.furiusmax.bjornlib.structures.ComplexStructure;
import com.furiusmax.bjornlib.structures.ComplexStructureManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ComplexStructureLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final HolderLookup.Provider registries;

    public ComplexStructureLoader(HolderLookup.Provider registries) {
        super(GSON, "complex_structures");
        this.registries = registries;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> dataMap, @Nonnull ResourceManager mgr, @NotNull ProfilerFiller prof) {
        ComplexStructureManager.LOADED.clear();
        dataMap.forEach((rl, json) -> {
            try {
                JsonObject obj = json.getAsJsonObject();
                if (obj.entrySet().isEmpty()) {
                    BjornLib.LOGGER.info("Complex Structure {} has been disabled", rl);
                } else {
                    ComplexStructure structure = (ComplexStructure)ComplexStructure.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow();
                    ComplexStructureManager.LOADED.put((ResourceLocation)rl, structure);
                    BjornLib.LOGGER.info("Successfully added new Complex Structure {}", rl);
                }
            }
            catch (NullPointerException ex) {
                BjornLib.LOGGER.error("Skipping registration of Complex Structure {} due to errors", rl);
                ex.printStackTrace();
            }
        });
    }
}

