/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.neo.mixin.structures;

import com.furiusmax.bjornlib.BjornLib;
import com.furiusmax.bjornlib.neo.mixin.structures.AccessorSinglePoolElement;
import com.furiusmax.bjornlib.structures.ComplexStructure;
import com.furiusmax.bjornlib.structures.ComplexStructureManager;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement$Placer"})
public class JigsawPlacementPlacerMixin {
    @Final
    @Shadow
    private Registry<StructureTemplatePool> pools;
    @Unique
    private int piecesGenerated;
    @Unique
    private ResourceKey<StructureTemplatePool> currentInjectedPool = null;
    @Unique
    private Set<ResourceLocation> injectedRooms = new HashSet<ResourceLocation>();

    public boolean hasInjected(ResourceLocation id) {
        return this.injectedRooms.contains(id);
    }

    public void markInjected(ResourceLocation id) {
        this.injectedRooms.add(id);
    }

    @ModifyArg(method={"tryPlacingChildren(Lnet/minecraft/world/level/levelgen/structure/PoolElementStructurePiece;Lorg/apache/commons/lang3/mutable/MutableObject;IZLnet/minecraft/world/level/LevelHeightAccessor;Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/levelgen/structure/pools/alias/PoolAliasLookup;Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/Registry;getHolder(Lnet/minecraft/resources/ResourceKey;)Ljava/util/Optional;"))
    private ResourceKey<StructureTemplatePool> forceSpecialRoomsPool(ResourceKey<StructureTemplatePool> resourceKey) {
        ResourceLocation poolPath = resourceKey.location();
        if (!ComplexStructureManager.isValidNameSpace(poolPath.getNamespace())) {
            return resourceKey;
        }
        List<ComplexStructure> complexStructures = ComplexStructureManager.getAllFromNameSpace(poolPath.getNamespace());
        if (complexStructures.isEmpty()) {
            return resourceKey;
        }
        for (ComplexStructure structure : complexStructures) {
            for (ComplexStructure.InjectedPiece piece : structure.getInjectedPieces()) {
                ResourceKey poolKey;
                if (!piece.getInjectOnPool().equals((Object)poolPath) || this.piecesGenerated <= piece.getAfterPiece() || this.injectedRooms.contains(piece.getInjectedFromPool()) || !this.pools.getOptional(poolKey = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)piece.getInjectedFromPool())).isPresent()) continue;
                this.currentInjectedPool = poolKey;
                BjornLib.LOGGER.info("Injecting pool {} after {} pieces", (Object)poolKey, (Object)this.piecesGenerated);
                return poolKey;
            }
        }
        this.currentInjectedPool = resourceKey;
        return resourceKey;
    }

    @Inject(method={"tryPlacingChildren(Lnet/minecraft/world/level/levelgen/structure/PoolElementStructurePiece;Lorg/apache/commons/lang3/mutable/MutableObject;IZLnet/minecraft/world/level/LevelHeightAccessor;Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/levelgen/structure/pools/alias/PoolAliasLookup;Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=0)})
    private void onPiecePlaced(CallbackInfo ci) {
        ++this.piecesGenerated;
    }

    @ModifyVariable(method={"tryPlacingChildren"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"), ordinal=0)
    private PoolElementStructurePiece detectBossOrChestPiece(PoolElementStructurePiece piece) {
        StructurePoolElement element = piece.getElement();
        if (element instanceof AccessorSinglePoolElement) {
            AccessorSinglePoolElement accessor = (AccessorSinglePoolElement)element;
            ResourceLocation loc = accessor.getTemplate().left().orElse(null);
            StructureTemplate template = accessor.getTemplate().right().orElse(null);
            if (this.currentInjectedPool != null) {
                ResourceLocation injectedLocation = this.currentInjectedPool.location();
                List<ComplexStructure> complexStructureList = ComplexStructureManager.getAllFromNameSpace(injectedLocation.getNamespace());
                if (complexStructureList.isEmpty()) {
                    return piece;
                }
                Optional<ComplexStructure> complexStructure = complexStructureList.stream().filter(cs -> cs.anyInjectedPiecePoolMatch(injectedLocation)).findFirst();
                if (complexStructure.isEmpty()) {
                    return piece;
                }
                Optional<ComplexStructure.InjectedPiece> injectedPiece = complexStructure.get().getInjectedPieceFromInjectedPool(injectedLocation);
                if (injectedPiece.isEmpty()) {
                    return piece;
                }
                this.markInjected(injectedLocation);
                BjornLib.LOGGER.info(String.valueOf(injectedLocation) + " special piece generated successfully");
                BjornLib.LOGGER.info(String.valueOf(this.injectedRooms) + " injectedPools successfully");
            }
        }
        return piece;
    }
}

