/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.neo.mixin.structures;

import com.furiusmax.bjornlib.BjornLib;
import com.furiusmax.bjornlib.neo.mixin.structures.StructurePiecesBuilderAccessor;
import com.furiusmax.bjornlib.structures.ComplexStructure;
import com.furiusmax.bjornlib.structures.ComplexStructureManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={JigsawPlacement.class})
public abstract class JigsawPlacementMixin {
    private static final List<ResourceLocation> realms = List.of(ResourceLocation.parse((String)"drealms:realm_prison_e/realm"), ResourceLocation.parse((String)"drealms:realm_forest_e/realm"));

    @Inject(method={"addPieces"}, at={@At(value="RETURN")}, cancellable=true)
    private static void retryStructureGeneration(Structure.GenerationContext context, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, BlockPos pos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, PoolAliasLookup aliasLookup, DimensionPadding dimensionPadding, LiquidSettings liquidSettings, CallbackInfoReturnable<Optional<Structure.GenerationStub>> cir) {
        if (!ComplexStructureManager.isCustomStructure(startPool)) {
            return;
        }
        Optional<ComplexStructure> complexStructure = ComplexStructureManager.getCustomStructure(startPool);
        if (complexStructure.isEmpty()) {
            return;
        }
        Optional optionalStub = (Optional)cir.getReturnValue();
        if (optionalStub.isEmpty()) {
            return;
        }
        Structure.GenerationStub originalStub = (Structure.GenerationStub)optionalStub.get();
        BlockPos origin = originalStub.position();
        int MIN_PIECES = complexStructure.get().getMinPieces();
        int MAX_ATTEMPTS = complexStructure.get().getMaxTries();
        boolean STOP_IF_INSUFFICIENT = complexStructure.get().stopAfterMaxTry();
        BjornLib.LOGGER.info("Adding pieces for the structure with starting pool " + String.valueOf(startPool.getKey().location()));
        Structure.GenerationStub wrappedStub = new Structure.GenerationStub(origin, finalBuilder -> {
            for (int attempt = 1; attempt <= MAX_ATTEMPTS; ++attempt) {
                StructurePiecesBuilderAccessor tempBuilder = (StructurePiecesBuilderAccessor)originalStub.getPiecesBuilder();
                if (tempBuilder.getPieces().size() >= MIN_PIECES) {
                    for (StructurePiece piece : tempBuilder.getPieces()) {
                        finalBuilder.addPiece(piece);
                    }
                    BjornLib.LOGGER.info("Structure will be generated with " + tempBuilder.getPieces().size() + " pieces");
                    return;
                }
                BjornLib.LOGGER.info("Attempt " + attempt + " / " + MAX_ATTEMPTS + " failed (" + tempBuilder.getPieces().size() + " pieces of " + MIN_PIECES + ")");
            }
            StructurePiecesBuilderAccessor tempBuilder = (StructurePiecesBuilderAccessor)originalStub.getPiecesBuilder();
            if (!STOP_IF_INSUFFICIENT && !tempBuilder.getPieces().isEmpty()) {
                for (StructurePiece piece : tempBuilder.getPieces()) {
                    finalBuilder.addPiece(piece);
                }
                BjornLib.LOGGER.info("Insufficient pieces, but structure will still be generated with " + tempBuilder.getPieces().size() + " pieces");
            } else {
                BjornLib.LOGGER.info("All attempts failed, no structure will be generated.");
            }
        });
        cir.setReturnValue(Optional.of(wrappedStub));
    }
}

