/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.neo.mixin.client;

import com.furiusmax.bjornlib.BjornLibImpl;
import com.furiusmax.bjornlib.morph.AbstractEntityMorph;
import com.furiusmax.bjornlib.morph.AbstractPlayerMorph;
import com.furiusmax.bjornlib.morph.IMorph;
import com.furiusmax.bjornlib.neo.mixin.EntityAccessor;
import com.furiusmax.bjornlib.neo.mixin.LimbAnimatorAccessor;
import com.furiusmax.bjornlib.neo.mixin.LivingEntityAccessor;
import com.furiusmax.bjornlib.neo.mixin.client.LivingEntityRendererAccessor;
import com.furiusmax.bjornlib.neo.mixin.client.QuadrupedModelAccessor;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerEntityRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public PlayerEntityRendererMixin(EntityRendererProvider.Context p_174289_, PlayerModel<AbstractClientPlayer> p_174290_, float p_174291_) {
        super(p_174289_, p_174290_, p_174291_);
    }

    @Shadow
    @Contract(pure=true)
    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable HumanoidModel.ArmPose getArmPose(AbstractClientPlayer player, InteractionHand hand) {
        return null;
    }

    @Inject(method={"renderNameTag"}, at={@At(value="HEAD")}, cancellable=true)
    private void injected(AbstractClientPlayer p_117808_, Component p_114499_, PoseStack p_114500_, MultiBufferSource p_114501_, int p_114502_, float p_334448_, CallbackInfo callbackInfo) {
        LivingEntity entity;
        AbstractEntityMorph entityMorph;
        IMorph morph = BjornLibImpl.INSTANCE.getPlayerMorph((Player)p_117808_);
        if (morph != null && morph instanceof AbstractEntityMorph && (entityMorph = (AbstractEntityMorph)morph).getEntityMorph() != null && (entity = (LivingEntity)entityMorph.getEntityMorph()) != null && !(entity instanceof Player)) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"getTextureLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void injected(AbstractClientPlayer abstractClientPlayer, CallbackInfoReturnable<ResourceLocation> cir) {
        AbstractPlayerMorph playerMorph;
        IMorph morph = BjornLibImpl.INSTANCE.getPlayerMorph((Player)abstractClientPlayer);
        if (morph != null && morph instanceof AbstractPlayerMorph && (playerMorph = (AbstractPlayerMorph)morph).getPlayerMorph() != null) {
            PlayerInfo playerinfo = Minecraft.getInstance().getConnection().getPlayerInfo(playerMorph.getPlayerMorph());
            cir.setReturnValue((Object)(playerinfo == null ? DefaultPlayerSkin.get((UUID)playerMorph.getPlayerMorph()).texture() : playerinfo.getSkin().texture()));
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"))
    private void redirectRender(LivingEntityRenderer<AbstractClientPlayer, EntityModel<AbstractClientPlayer>> renderer, LivingEntity player, float f, float g, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        AbstractEntityMorph entityMorph;
        IMorph abstractMorph = BjornLibImpl.INSTANCE.getPlayerMorph((Player)player);
        if (abstractMorph != null && abstractMorph instanceof AbstractEntityMorph && (entityMorph = (AbstractEntityMorph)abstractMorph).getEntityMorph() != null) {
            LivingEntity morph = (LivingEntity)entityMorph.getEntityMorph();
            if (morph != null && !(morph instanceof Player)) {
                ((LimbAnimatorAccessor)morph.walkAnimation).setPrevSpeed(((LimbAnimatorAccessor)player.walkAnimation).getPrevSpeed());
                morph.walkAnimation.setSpeed(player.walkAnimation.speed());
                ((LimbAnimatorAccessor)morph.walkAnimation).setPos(player.walkAnimation.position());
                morph.swinging = player.swinging;
                morph.swingTime = player.swingTime;
                morph.oAttackAnim = player.oAttackAnim;
                morph.attackAnim = player.attackAnim;
                morph.yBodyRot = player.yBodyRot;
                morph.yBodyRotO = player.yBodyRotO;
                morph.yHeadRot = player.yHeadRot;
                morph.yHeadRotO = player.yHeadRotO;
                morph.tickCount = player.tickCount;
                morph.swingingArm = player.swingingArm;
                ((LivingEntityAccessor)morph).setSwimAmount(((LivingEntityAccessor)player).getSwimAmount());
                ((LivingEntityAccessor)morph).setSwimAmountO(((LivingEntityAccessor)player).getSwimAmountO());
                morph.setOnGround(player.onGround());
                morph.setDeltaMovement(player.getDeltaMovement());
                morph.setInvisible(player.isInvisibleTo((Player)Minecraft.getInstance().player));
                ((EntityAccessor)morph).setVehicle(player.getVehicle());
                ((EntityAccessor)morph).setPassengers((ImmutableList<Entity>)ImmutableList.copyOf((Collection)player.getPassengers()));
                ((EntityAccessor)morph).setTouchingWater(player.isInWater());
                if (morph instanceof Phantom) {
                    morph.setXRot(-player.getXRot());
                    morph.xRotO = -player.xRotO;
                } else {
                    morph.setXRot(player.getXRot());
                    morph.xRotO = player.xRotO;
                }
                if (morph instanceof Mob) {
                    ((Mob)morph).setAggressive(player.isUsingItem());
                }
                morph.setPose(player.getPose());
                morph.startUsingItem(player.getUsedItemHand() == null ? InteractionHand.MAIN_HAND : player.getUsedItemHand());
                ((LivingEntityAccessor)morph).callSetLivingEntityFlag(1, player.isUsingItem());
                morph.getTicksUsingItem();
                ((LivingEntityAccessor)morph).callUpdatingUsingItem();
                morph.hurtTime = player.hurtTime;
                if (!player.isInvisibleTo((Player)Minecraft.getInstance().player) && !player.isSpectator()) {
                    EntityRenderer shapeRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)morph);
                    if (shapeRenderer instanceof HumanoidMobRenderer) {
                        this.shape_setBipedShapeModelPose((AbstractClientPlayer)player, morph, (LivingEntityRenderer<?, ?>)((HumanoidMobRenderer)shapeRenderer));
                    }
                    shapeRenderer.render((Entity)morph, f, g, matrixStack, buffer, packedLight);
                    if (player != Minecraft.getInstance().player) {
                        this.renderNameTag((Entity)((AbstractClientPlayer)player), player.getDisplayName(), matrixStack, buffer, packedLight, g);
                    }
                }
            } else {
                super.render((LivingEntity)((AbstractClientPlayer)player), f, g, matrixStack, buffer, packedLight);
            }
        } else {
            super.render((LivingEntity)((AbstractClientPlayer)player), f, g, matrixStack, buffer, packedLight);
        }
    }

    @Unique
    private void shape_setBipedShapeModelPose(AbstractClientPlayer player, LivingEntity shape, LivingEntityRenderer<?, ?> shapeRenderer) {
        HumanoidModel shapeBipedModel = (HumanoidModel)shapeRenderer.getModel();
        if (shape.isSpectator()) {
            shapeBipedModel.setAllVisible(false);
            shapeBipedModel.head.visible = true;
            shapeBipedModel.hat.visible = true;
        } else {
            shapeBipedModel.setAllVisible(true);
            shapeBipedModel.hat.visible = player.isModelPartShown(PlayerModelPart.HAT);
            shapeBipedModel.crouching = shape.isCrouching();
            HumanoidModel.ArmPose mainHandPose = PlayerEntityRendererMixin.getArmPose(player, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose offHandPose = PlayerEntityRendererMixin.getArmPose(player, InteractionHand.OFF_HAND);
            if (mainHandPose != null && mainHandPose.isTwoHanded()) {
                HumanoidModel.ArmPose armPose = offHandPose = shape.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (mainHandPose != null && offHandPose != null && shape.getMainArm() == HumanoidArm.RIGHT) {
                shapeBipedModel.rightArmPose = mainHandPose;
                shapeBipedModel.leftArmPose = offHandPose;
            } else if (mainHandPose != null && offHandPose != null) {
                shapeBipedModel.rightArmPose = offHandPose;
                shapeBipedModel.leftArmPose = mainHandPose;
            }
        }
    }

    @Inject(method={"renderHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        EntityRenderer renderer;
        LivingEntity morph;
        AbstractEntityMorph entityMorph;
        IMorph abstractMorph = BjornLibImpl.INSTANCE.getPlayerMorph((Player)player);
        if (abstractMorph != null && abstractMorph instanceof AbstractEntityMorph && (entityMorph = (AbstractEntityMorph)abstractMorph).getEntityMorph() != null && (morph = (LivingEntity)entityMorph.getEntityMorph()) != null && (renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)morph)) instanceof LivingEntityRenderer) {
            LivingEntityRenderer rendererCasted = (LivingEntityRenderer)renderer;
            EntityModel model = ((LivingEntityRenderer)renderer).getModel();
            arm = null;
            sleeve = null;
            if (model instanceof HumanoidModel) {
                arm = player.getMainArm() == HumanoidArm.RIGHT ? ((HumanoidModel)model).rightArm : ((HumanoidModel)model).leftArm;
                if (model instanceof PlayerModel) {
                    sleeve = ((PlayerModel)model).rightSleeve;
                }
            } else if (model instanceof QuadrupedModel) {
                arm = player.getMainArm() == HumanoidArm.RIGHT ? ((QuadrupedModelAccessor)((QuadrupedModel)model)).getRightFrontLeg() : ((QuadrupedModelAccessor)((QuadrupedModel)model)).getLeftFrontLeg();
                matrices.translate(0.0, -0.35, 0.5);
            }
            model.attackTime = 0.0f;
            model.setupAnim((Entity)morph, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (arm != null) {
                arm.xRot = 0.0f;
                arm.render(matrices, vertexConsumers.getBuffer(((LivingEntityRendererAccessor)rendererCasted).callGetRenderType(morph, true, false, true)), light, OverlayTexture.NO_OVERLAY);
            }
            if (sleeve != null) {
                sleeve.xRot = 0.0f;
                sleeve.render(matrices, vertexConsumers.getBuffer(((LivingEntityRendererAccessor)rendererCasted).callGetRenderType(morph, true, false, true)), light, OverlayTexture.NO_OVERLAY);
            }
            ci.cancel();
        }
    }
}

