/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.neo;

import com.furiusmax.bjornlib.morph.AbstractEntityMorph;
import com.furiusmax.bjornlib.morph.AbstractPlayerMorph;
import com.furiusmax.bjornlib.morph.IMorph;
import com.furiusmax.bjornlib.neo.AttachmentsRegistry;
import com.furiusmax.bjornlib.neo.SyncPlayerMorphToClient;
import com.furiusmax.bjornlib.registry.MorphRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="bjornlib", bus=EventBusSubscriber.Bus.GAME)
public class PlayerMorphAttachment
implements INBTSerializable {
    private IMorph morph;

    public IMorph getMorph() {
        return this.morph;
    }

    public void setMorph(IMorph morph) {
        this.morph = morph;
    }

    public void setMorph(IMorph morph, Player player) {
        if (this.morph != null) {
            this.morph.unMorph(player);
        }
        this.morph = morph;
        this.morph.morph(player);
        player.refreshDimensions();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.morph != null) {
            CompoundTag morphTag = new CompoundTag();
            String id = this.morph.id().toString();
            CompoundTag morphSavedTag = this.morph.saveData(new CompoundTag());
            morphTag.putString("morphId", id);
            morphTag.put("morphSavedTag", (Tag)morphSavedTag);
            tag.put("morph", (Tag)morphTag);
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, Tag tag) {
        CompoundTag compoundTag;
        if (tag instanceof CompoundTag && (compoundTag = (CompoundTag)tag).contains("morph")) {
            CompoundTag morphTag = compoundTag.getCompound("morph");
            ResourceLocation id = ResourceLocation.parse((String)morphTag.getString("morphId"));
            CompoundTag morphSavedTag = morphTag.getCompound("morphSavedTag");
            IMorph mrp = MorphRegistry.getMorph(id).clone();
            mrp.readData(morphSavedTag);
            this.morph = mrp;
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof Player && !event.getEntity().level().isClientSide) {
            PlayerMorphAttachment capability = (PlayerMorphAttachment)event.getEntity().getData(AttachmentsRegistry.PLAYER_MORPH);
            if (capability == null) {
                return;
            }
            if (capability.morph != null) {
                capability.morph.morph(event.getEntity());
            }
            ((ServerPlayer)event.getEntity()).connection.send((CustomPacketPayload)new SyncPlayerMorphToClient(capability.serializeNBT((HolderLookup.Provider)event.getEntity().registryAccess()), event.getEntity().getUUID()));
        }
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        PlayerMorphAttachment capability = (PlayerMorphAttachment)event.getEntity().getData(AttachmentsRegistry.PLAYER_MORPH);
        if (capability == null) {
            return;
        }
        if (capability.morph != null) {
            capability.morph.tick(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().level().isClientSide) {
            PlayerMorphAttachment capability = (PlayerMorphAttachment)event.getEntity().getData(AttachmentsRegistry.PLAYER_MORPH);
            if (capability == null) {
                return;
            }
            if (capability.morph != null) {
                capability.morph.morph(event.getEntity());
            }
            ((ServerPlayer)event.getEntity()).connection.send((CustomPacketPayload)new SyncPlayerMorphToClient(capability.serializeNBT((HolderLookup.Provider)event.getEntity().registryAccess()), event.getEntity().getUUID()));
            event.getEntity().heal((float)event.getEntity().getAttribute(Attributes.MAX_HEALTH).getValue());
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTrackingEvent(PlayerEvent.StartTracking event) {
        if (event.getEntity() instanceof Player && !event.getEntity().level().isClientSide) {
            PlayerMorphAttachment capability = (PlayerMorphAttachment)event.getEntity().getData(AttachmentsRegistry.PLAYER_MORPH);
            if (capability == null) {
                return;
            }
            if (capability.morph != null) {
                capability.morph.morph(event.getEntity());
            }
            ((ServerPlayer)event.getEntity()).connection.send((CustomPacketPayload)new SyncPlayerMorphToClient(capability.serializeNBT((HolderLookup.Provider)event.getEntity().registryAccess()), event.getEntity().getUUID()));
        }
    }

    @SubscribeEvent
    public static void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!event.getEntity().level().isClientSide) {
                PlayerMorphAttachment capability = (PlayerMorphAttachment)event.getEntity().getData(AttachmentsRegistry.PLAYER_MORPH);
                if (capability == null) {
                    return;
                }
                if (capability.morph != null) {
                    capability.morph.morph(event.getEntity());
                }
                ((ServerPlayer)event.getEntity()).connection.send((CustomPacketPayload)new SyncPlayerMorphToClient(capability.serializeNBT((HolderLookup.Provider)event.getEntity().registryAccess()), event.getEntity().getUUID()));
            }
        }
    }

    @SubscribeEvent
    public static void changeSize(EntityEvent.Size event) {
        Entity entity;
        if (event.getEntity().isAddedToLevel() && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            PlayerMorphAttachment morphCapability = (PlayerMorphAttachment)event.getEntity().getData(AttachmentsRegistry.PLAYER_MORPH);
            if (morphCapability != null && morphCapability.getMorph() != null && morphCapability.getMorph() instanceof AbstractEntityMorph) {
                event.setNewSize(((AbstractEntityMorph)morphCapability.getMorph()).getEntityMorph().getType().getDimensions());
            }
        }
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, PlayerMorphAttachment> {
        @NotNull
        public PlayerMorphAttachment read(@NotNull IAttachmentHolder holder, @NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                PlayerMorphAttachment morphAttachment = new PlayerMorphAttachment();
                morphAttachment.deserializeNBT(provider, (Tag)tag);
                return morphAttachment;
            }
            throw new IllegalArgumentException("Holder is not a player");
        }

        public CompoundTag write(PlayerMorphAttachment attachment, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    }

    @EventBusSubscriber(modid="bjornlib", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    static class NameTagManager {
        NameTagManager() {
        }

        @SubscribeEvent
        public static void renderNameTag(RenderNameTagEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                PlayerInfo playerinfo;
                AbstractPlayerMorph playerMorph;
                IMorph iMorph;
                Player player = (Player)entity;
                PlayerMorphAttachment morphCapability = (PlayerMorphAttachment)event.getEntity().getData(AttachmentsRegistry.PLAYER_MORPH);
                if (morphCapability != null && morphCapability.getMorph() != null && (iMorph = morphCapability.getMorph()) instanceof AbstractPlayerMorph && (playerMorph = (AbstractPlayerMorph)iMorph).getPlayerMorph() != null && (playerinfo = Minecraft.getInstance().getConnection().getPlayerInfo(playerMorph.getPlayerMorph())) != null) {
                    event.setContent((Component)Component.literal((String)playerinfo.getProfile().getName()));
                }
            }
        }
    }
}

