/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.neo;

import com.furiusmax.bjornlib.BjornLib;
import com.furiusmax.bjornlib.neo.AttachmentsRegistry;
import com.furiusmax.bjornlib.neo.Networking;
import com.furiusmax.bjornlib.neo.structure.ComplexStructureLoader;
import com.furiusmax.bjornlib.registry.AbilityRegistry;
import com.furiusmax.bjornlib.registry.ItemRegistry;
import com.furiusmax.bjornlib.registry.ParticleRegistry;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

@Mod(value="bjornlib")
public final class BjornLibNeo {
    public static BjornLibNeo instance;

    public BjornLibNeo(IEventBus modEventBus) {
        BjornLib.init();
        BjornLibNeo.bind(modEventBus, Registries.PARTICLE_TYPE, ParticleRegistry::registerParticles);
        BjornLibNeo.bind(modEventBus, Registries.ITEM, ItemRegistry::registerItems);
        BjornLibNeo.bind(modEventBus, AbilityRegistry.ABILITY_REGISTRY, AbilityRegistry::register);
        AttachmentsRegistry.ATTACHMENTS.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, this::onSlashReload);
        modEventBus.addListener(this::commonSetup);
        modEventBus.register(Networking.class);
        instance = this;
    }

    private static <T> void bind(IEventBus modEventBus, ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        modEventBus.addListener(event -> {
            if (registry.equals(event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    public void onSlashReload(AddReloadListenerEvent evt) {
        evt.addListener((PreparableReloadListener)new ComplexStructureLoader((HolderLookup.Provider)evt.getRegistryAccess()));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }
}

