/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.neo;

import com.furiusmax.bjornlib.BjornLibImpl;
import com.furiusmax.bjornlib.ability.AbilityType;
import com.furiusmax.bjornlib.capability.IPlayerAbilities;
import com.furiusmax.bjornlib.morph.IMorph;
import com.furiusmax.bjornlib.neo.AbilityEvents;
import com.furiusmax.bjornlib.neo.AttachmentsRegistry;
import com.furiusmax.bjornlib.neo.PlayerMorphAttachment;
import com.furiusmax.bjornlib.registry.AbilityRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class BjornLibImpl
implements com.furiusmax.bjornlib.BjornLibImpl {
    @Override
    public void fireAbilityEvent(Player player, IPlayerAbilities playerAbilities, AbilityType abilityType, BjornLibImpl.SkillEvent skillEvent) {
        AbilityEvents event = null;
        if (skillEvent == BjornLibImpl.SkillEvent.ADD) {
            event = new AbilityEvents.AddSkill(player, abilityType, playerAbilities);
        } else if (skillEvent == BjornLibImpl.SkillEvent.REMOVE) {
            event = new AbilityEvents.RemoveSkill(player, abilityType, playerAbilities);
        } else if (skillEvent == BjornLibImpl.SkillEvent.UPDATE) {
            event = new AbilityEvents.UpdateSkill(player, abilityType, playerAbilities);
        } else if (skillEvent == BjornLibImpl.SkillEvent.CAST) {
            event = new AbilityEvents.CastAbility(player, abilityType, playerAbilities);
        } else if (skillEvent == BjornLibImpl.SkillEvent.CONTINUOUS) {
            event = new AbilityEvents.CastContinuousAbility(player, abilityType, playerAbilities);
        } else if (skillEvent == BjornLibImpl.SkillEvent.RELEASE) {
            event = new AbilityEvents.releaseAbility(player, abilityType, playerAbilities);
        }
        if (event != null) {
            NeoForge.EVENT_BUS.post((Event)event);
        }
    }

    @Override
    public void setEntityLevel(Entity entity, int level) {
        entity.getPersistentData().putInt("entityLevel", level);
    }

    @Override
    public IMorph getPlayerMorph(Player player) {
        PlayerMorphAttachment morphCapability = (PlayerMorphAttachment)player.getData(AttachmentsRegistry.PLAYER_MORPH);
        return morphCapability.getMorph();
    }

    @Override
    public Registry<AbilityType> getAbilityRegistry() {
        return (Registry)BuiltInRegistries.REGISTRY.get(AbilityRegistry.ABILITY_REGISTRY.location());
    }
}

