/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.leveling;

import com.furiusmax.bjornlib.BjornLibImpl;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.npc.Villager;

public class EntityLevelBuilder {
    public static Builder create(LivingEntity entity, ServerLevel serverLevel) {
        return new Builder(entity, serverLevel);
    }

    public static class Builder {
        static final Random random = new Random();
        LivingEntity entity;
        ServerLevel serverLevel;
        int playerLevel;
        int maxPlayerLevel;
        int defaultDimensionLevel;
        int aboveLevelRange;
        int belowLevelRange;
        double healthFactor = 0.7;
        double damageFactor = 0.8;
        double damageMultiplier = 6.0;
        Map<ResourceLocation, Integer> dimensionLevels;
        executeExtraCode extras;

        protected Builder(LivingEntity entity, ServerLevel serverLevel) {
            this.entity = entity;
            this.serverLevel = serverLevel;
        }

        public Builder nearestPlayerLevel(int playerLevel) {
            this.playerLevel = playerLevel;
            return this;
        }

        public Builder maxPlayerLevel(int max) {
            this.maxPlayerLevel = max;
            return this;
        }

        public Builder setDefaulDimensionLevel(int level) {
            this.defaultDimensionLevel = level;
            return this;
        }

        public Builder setLevelRange(int above, int below) {
            this.aboveLevelRange = above;
            this.belowLevelRange = below;
            return this;
        }

        public Builder setLevelRange(int range) {
            this.aboveLevelRange = range;
            this.belowLevelRange = range;
            return this;
        }

        public Builder executeExtraCode(executeExtraCode extras) {
            this.extras = extras;
            return this;
        }

        public Builder setDimensionsCap(Map<ResourceLocation, Integer> map) {
            this.dimensionLevels = map;
            return this;
        }

        public Builder setHealthScaleFactor(double factor) {
            this.healthFactor = factor;
            return this;
        }

        public Builder setDamageScaleFactor(double factor) {
            this.damageFactor = factor;
            return this;
        }

        public Builder setDamageMultiplier(float multiply) {
            this.damageMultiplier = multiply;
            return this;
        }

        public Builder changeAttributes() {
            int mobLevel = Math.max(1, random.nextInt(this.playerLevel - this.belowLevelRange, this.playerLevel + this.aboveLevelRange + 1));
            if (this.extras != null) {
                this.extras.executeExtraCode();
            }
            for (Map.Entry<ResourceLocation, Integer> entry : this.dimensionLevels.entrySet()) {
                if (this.serverLevel.dimension().location().equals((Object)entry.getKey()) && mobLevel < entry.getValue()) {
                    mobLevel = entry.getValue();
                }
                if (this.dimensionLevels.containsKey(this.serverLevel.dimension().location()) || mobLevel >= this.defaultDimensionLevel) continue;
                mobLevel = this.defaultDimensionLevel;
            }
            if (mobLevel > this.maxPlayerLevel) {
                mobLevel = this.maxPlayerLevel;
            }
            if (!(this.entity instanceof EnderDragon) && this.entity instanceof LivingEntity) {
                if (this.entity.getAttributes().hasAttribute(Attributes.MAX_HEALTH)) {
                    double mobHealth = (double)mobLevel * (this.entity.getAttribute(Attributes.MAX_HEALTH).getValue() * this.healthFactor);
                    this.entity.getAttribute(Attributes.MAX_HEALTH).setBaseValue(mobHealth);
                    this.entity.heal(this.entity.getMaxHealth());
                }
                if (this.entity.getAttributes().hasAttribute(Attributes.ATTACK_DAMAGE)) {
                    double mobDamage = (double)mobLevel * (this.entity.getAttribute(Attributes.ATTACK_DAMAGE).getValue() * this.damageFactor) * this.damageMultiplier;
                    this.entity.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(mobDamage);
                }
            }
            if (this.entity.getCustomName() == null) {
                if (BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.entity.getType()).getNamespace().equals("mca")) {
                    this.entity.setCustomName((Component)Component.literal((String)(Component.translatable((String)this.entity.getType().getDescriptionId()).getString() + " Level : " + mobLevel)));
                } else if (this.entity instanceof Villager) {
                    this.entity.setCustomName((Component)Component.literal((String)(this.entity.getName().getString() + " Level : " + mobLevel)));
                } else {
                    this.entity.setCustomName((Component)Component.literal((String)(Component.translatable((String)this.entity.getType().getDescriptionId()).getString() + " Level : " + mobLevel)));
                }
            } else {
                this.entity.setCustomName((Component)Component.literal((String)(this.entity.getCustomName().getString() + " Level : " + mobLevel)));
            }
            BjornLibImpl.INSTANCE.setEntityLevel((Entity)this.entity, mobLevel);
            return this;
        }
    }

    public static interface executeExtraCode {
        public void executeExtraCode();
    }
}

