/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.client.particle;

import com.furiusmax.bjornlib.registry.ParticleRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.DoubleStream;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;

public class LightningParticleOptions
implements ParticleOptions {
    public Vec3 pos;
    public float xRot;
    public float yRot;
    public int parts;
    public float offset;
    public int divisionCount;
    public float divisionRandomOffset;
    public Vec3 size;
    public int middleColor;
    public int outterColor;
    public float speed;
    public static StreamCodec<? super FriendlyByteBuf, LightningParticleOptions> STREAM_CODEC = StreamCodec.of((buf, option) -> {
        buf.writeVec3(option.pos);
        buf.writeFloat(option.xRot);
        buf.writeFloat(option.yRot);
        buf.writeInt(option.parts);
        buf.writeFloat(option.offset);
        buf.writeInt(option.divisionCount);
        buf.writeFloat(option.divisionRandomOffset);
        buf.writeVec3(option.size);
        buf.writeInt(option.middleColor);
        buf.writeInt(option.outterColor);
        buf.writeFloat(option.speed);
    }, buf -> new LightningParticleOptions(buf.readVec3(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readFloat(), buf.readInt(), buf.readFloat(), buf.readVec3(), buf.readInt(), buf.readInt(), buf.readFloat()));
    static PrimitiveCodec<DoubleStream> DOUBLE_STREAM = new PrimitiveCodec<DoubleStream>(){

        public <T> DataResult<DoubleStream> read(DynamicOps<T> ops, T input) {
            return ops.getStream(input).flatMap(stream -> {
                List list = stream.toList();
                if (list.stream().allMatch(element -> ops.getNumberValue(element).isSuccess())) {
                    return DataResult.success((Object)list.stream().mapToDouble(element -> ((Number)ops.getNumberValue(element).getOrThrow()).doubleValue()));
                }
                return DataResult.error(() -> "Some elements are not doubles: " + String.valueOf(input));
            });
        }

        public <T> T write(DynamicOps<T> ops, DoubleStream value) {
            return (T)ops.createList(value.mapToObj(arg_0 -> ops.createDouble(arg_0)));
        }

        public String toString() {
            return "DoubleStream";
        }
    };
    public static MapCodec<LightningParticleOptions> MAP_CODEC = RecordCodecBuilder.mapCodec(object -> object.group((App)DOUBLE_STREAM.fieldOf("pos").forGetter(option -> DoubleStream.of(option.pos.x, option.pos.y, option.pos.z)), (App)Codec.FLOAT.fieldOf("xRot").forGetter(option -> Float.valueOf(option.xRot)), (App)Codec.FLOAT.fieldOf("yRot").forGetter(option -> Float.valueOf(option.yRot)), (App)Codec.INT.fieldOf("parts").forGetter(option -> option.parts), (App)Codec.FLOAT.fieldOf("offset").forGetter(option -> Float.valueOf(option.offset)), (App)Codec.INT.fieldOf("divisionCount").forGetter(option -> option.divisionCount), (App)Codec.FLOAT.fieldOf("divisionRandomOffset").forGetter(option -> Float.valueOf(option.divisionRandomOffset)), (App)DOUBLE_STREAM.fieldOf("size").forGetter(option -> DoubleStream.of(option.size.x, option.size.y, option.size.z)), (App)Codec.INT.fieldOf("middleColor").forGetter(option -> option.middleColor), (App)Codec.INT.fieldOf("outterColor").forGetter(option -> option.outterColor), (App)Codec.FLOAT.fieldOf("speed").forGetter(option -> Float.valueOf(option.speed))).apply((Applicative)object, (pos, xRot, yRot, parts, offset, division, divRandom, size, midColor, outColor, speed) -> {
        double[] array = pos.toArray();
        double[] array2 = size.toArray();
        return new LightningParticleOptions(new Vec3(array[0], array[1], array[2]), xRot.floatValue(), yRot.floatValue(), (int)parts, offset.floatValue(), (int)division, division.intValue(), new Vec3(array2[0], array2[1], array2[2]), (int)midColor, (int)outColor, speed.floatValue());
    }));

    public LightningParticleOptions(Vec3 pos, float xRot, float yRot, int parts, float offset, int divisionCount, float divisionRandomOffset, Vec3 size, int middleColor, int outterColor, float speed) {
        this.pos = pos;
        this.xRot = xRot;
        this.yRot = yRot;
        this.parts = parts;
        this.offset = offset;
        this.divisionCount = divisionCount;
        this.divisionRandomOffset = divisionRandomOffset;
        this.size = size;
        this.middleColor = middleColor;
        this.outterColor = outterColor;
        this.speed = speed;
    }

    public LightningParticleOptions(Vec3 pos, float xRot, float yRot, int parts, float offset, int divisionCount, float divisionRandomOffset, int sizeX, int sizeY, int sizeZ, int middleColor, int outterColor, float speed) {
        this.pos = pos;
        this.xRot = xRot;
        this.yRot = yRot;
        this.parts = parts;
        this.offset = offset;
        this.divisionCount = divisionCount;
        this.divisionRandomOffset = divisionRandomOffset;
        this.size = new Vec3((double)sizeX, (double)sizeY, (double)sizeZ);
        this.middleColor = middleColor;
        this.outterColor = outterColor;
        this.speed = speed;
    }

    public ParticleType<?> getType() {
        return ParticleRegistry.LIGHTNING_PARTICLE;
    }
}

