/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.client.particle;

import com.furiusmax.bjornlib.client.particle.LightningParticleOptions;
import com.furiusmax.bjornlib.misc.client.lightning.LightningBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;

public class LightningParticle
extends TextureSheetParticle {
    LightningParticleOptions options;
    public List<Vec3> rayPositions = new ArrayList<Vec3>();

    public LightningParticle(ClientLevel world, LightningParticleOptions data, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.options = data;
        this.lifetime = 50;
        this.setPos(x, y, z);
        this.hasPhysics = false;
        this.setBoundingBox(this.getBoundingBox().inflate(20.0));
    }

    protected int getLightColor(float p_107249_) {
        return 0xF000F0;
    }

    public void render(VertexConsumer b, Camera info, float pticks) {
        System.out.println(pticks);
        LightningBuilder.create(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)).setParts(this.options.parts).setRandomOffset(this.options.offset).setdivisionCount(this.options.divisionCount).setDivisionRandomOffset(this.options.divisionRandomOffset).setPositionList(this.rayPositions).setSize((float)(this.options.size.x * (double)0.2f), (float)(this.options.size.y * (double)0.55f), (float)this.options.size.z).setmiddleColor(this.options.middleColor).setOutterColor(this.options.outterColor).setDelay(this.options.speed).renderLightning(info, this.options.pos, this.options.xRot, this.options.yRot, (int)pticks, new PoseStack(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource());
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }
}

