/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.client.particle;

import com.furiusmax.bjornlib.BjornLibStreamCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class GenericParticleData
implements ParticleOptions {
    public float r1 = 1.0f;
    public float g1 = 1.0f;
    public float b1 = 1.0f;
    public float a1 = 1.0f;
    public float r2 = 1.0f;
    public float g2 = 1.0f;
    public float b2 = 1.0f;
    public float a2 = 0.0f;
    public float scale1 = 1.0f;
    public float scale2 = 0.0f;
    public int lifetime = 20;
    public float spin = 0.0f;
    public boolean gravity = false;
    public String ownerUUID = "";
    ParticleType<?> type;

    public GenericParticleData(Float r1, Float g1, Float b1, Float a1, Float r2, Float g2, Float b2, Float a2, Float scale1, Float scale2, Integer lifetime, Float spin, Boolean gravity, String ownerUUID, String id) {
        this.r1 = r1.floatValue();
        this.g1 = g1.floatValue();
        this.b1 = b1.floatValue();
        this.a1 = a1.floatValue();
        this.r2 = r2.floatValue();
        this.g2 = g2.floatValue();
        this.b2 = b2.floatValue();
        this.a2 = a2.floatValue();
        this.scale1 = scale1.floatValue();
        this.scale2 = scale2.floatValue();
        this.lifetime = lifetime;
        this.spin = spin.floatValue();
        this.gravity = gravity;
        this.ownerUUID = ownerUUID;
        this.type = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)id));
    }

    public float getR1() {
        return this.r1;
    }

    public float getG1() {
        return this.g1;
    }

    public float getB1() {
        return this.b1;
    }

    public float getA1() {
        return this.a1;
    }

    public float getR2() {
        return this.r2;
    }

    public float getG2() {
        return this.g2;
    }

    public float getB2() {
        return this.b2;
    }

    public float getA2() {
        return this.a2;
    }

    public float getScale1() {
        return this.scale1;
    }

    public float getScale2() {
        return this.scale2;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public float getSpin() {
        return this.spin;
    }

    public boolean isGravity() {
        return this.gravity;
    }

    public String getOwnerUUID() {
        return this.ownerUUID;
    }

    public static MapCodec<GenericParticleData> codecFor(ParticleType<?> type) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("r1").forGetter(data -> Float.valueOf(data.r1)), (App)Codec.FLOAT.fieldOf("g1").forGetter(data -> Float.valueOf(data.g1)), (App)Codec.FLOAT.fieldOf("b1").forGetter(data -> Float.valueOf(data.b1)), (App)Codec.FLOAT.fieldOf("a1").forGetter(data -> Float.valueOf(data.a1)), (App)Codec.FLOAT.fieldOf("r2").forGetter(data -> Float.valueOf(data.r2)), (App)Codec.FLOAT.fieldOf("g2").forGetter(data -> Float.valueOf(data.g2)), (App)Codec.FLOAT.fieldOf("b2").forGetter(data -> Float.valueOf(data.b2)), (App)Codec.FLOAT.fieldOf("a2").forGetter(data -> Float.valueOf(data.a2)), (App)Codec.FLOAT.fieldOf("scale1").forGetter(data -> Float.valueOf(data.scale1)), (App)Codec.FLOAT.fieldOf("scale2").forGetter(data -> Float.valueOf(data.scale2)), (App)Codec.INT.fieldOf("lifetime").forGetter(data -> data.lifetime), (App)Codec.FLOAT.fieldOf("spin").forGetter(data -> Float.valueOf(data.spin)), (App)Codec.BOOL.fieldOf("gravity").forGetter(data -> data.gravity), (App)Codec.STRING.fieldOf("ownerUUID").forGetter(data -> data.ownerUUID)).apply((Applicative)instance, (r1, g1, b1, a1, r2, g2, b2, a2, scale1, scale2, lifetime, spin, gravity, ownerUUID) -> {
            GenericParticleData data = new GenericParticleData(type);
            data.r1 = r1.floatValue();
            data.g1 = g1.floatValue();
            data.b1 = b1.floatValue();
            data.a1 = a1.floatValue();
            data.r2 = r2.floatValue();
            data.g2 = g2.floatValue();
            data.b2 = b2.floatValue();
            data.a2 = a2.floatValue();
            data.scale1 = scale1.floatValue();
            data.scale2 = scale2.floatValue();
            data.lifetime = lifetime;
            data.spin = spin.floatValue();
            data.gravity = gravity;
            data.ownerUUID = ownerUUID;
            return data;
        }));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, GenericParticleData> streamCodecFor(ParticleType<?> type, ResourceLocation id) {
        return BjornLibStreamCodec.composite(ByteBufCodecs.FLOAT, GenericParticleData::getR1, ByteBufCodecs.FLOAT, GenericParticleData::getG1, ByteBufCodecs.FLOAT, GenericParticleData::getB1, ByteBufCodecs.FLOAT, GenericParticleData::getA1, ByteBufCodecs.FLOAT, GenericParticleData::getR2, ByteBufCodecs.FLOAT, GenericParticleData::getG2, ByteBufCodecs.FLOAT, GenericParticleData::getB2, ByteBufCodecs.FLOAT, GenericParticleData::getA2, ByteBufCodecs.FLOAT, GenericParticleData::getScale1, ByteBufCodecs.FLOAT, GenericParticleData::getScale2, ByteBufCodecs.INT, GenericParticleData::getLifetime, ByteBufCodecs.FLOAT, GenericParticleData::getSpin, ByteBufCodecs.BOOL, GenericParticleData::isGravity, ByteBufCodecs.STRING_UTF8, GenericParticleData::getOwnerUUID, ByteBufCodecs.STRING_UTF8, j -> id.toString(), GenericParticleData::new);
    }

    public ParticleType<?> getParticleType() {
        return this.type;
    }

    public GenericParticleData(ParticleType<?> type) {
        this.type = type;
    }

    public ParticleType<?> getType() {
        return this.type == null ? ParticleTypes.END_ROD : this.type;
    }
}

