/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.block;

import com.furiusmax.bjornlib.block.BaseDoubleBlock;
import com.furiusmax.bjornlib.block.DoubleBlockDirection;
import com.furiusmax.bjornlib.block.DoubleBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BaseDoubleBlockEntity
extends BlockEntity {
    public BaseDoubleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static BaseDoubleBlockEntity getBaseEntity(Level world, BlockPos pos, BlockState state, DoubleBlockDirection extensionDirection) {
        BlockEntity entity;
        BlockPos otherPos = pos;
        if (state.getValue(BaseDoubleBlock.PART) == DoubleBlockPart.EXTENSION) {
            Direction facing = (Direction)state.getValue((Property)BaseDoubleBlock.FACING);
            otherPos = switch (extensionDirection) {
                default -> throw new MatchException(null, null);
                case DoubleBlockDirection.FRONT -> pos.relative(facing.getOpposite());
                case DoubleBlockDirection.BACK -> pos.relative(facing);
                case DoubleBlockDirection.LEFT -> pos.relative(facing.getClockWise());
                case DoubleBlockDirection.RIGHT -> pos.relative(facing.getCounterClockWise());
                case DoubleBlockDirection.UP -> pos.below();
                case DoubleBlockDirection.DOWN -> pos.above();
            };
        }
        return (entity = world.getBlockEntity(otherPos)) instanceof BaseDoubleBlockEntity ? (BaseDoubleBlockEntity)entity : null;
    }
}

