/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.block;

import com.furiusmax.bjornlib.block.DoubleBlockDirection;
import com.furiusmax.bjornlib.block.DoubleBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDoubleBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockPart> PART = DoubleBlockPart.PART;
    protected final DoubleBlockDirection extensionDirection;

    public BaseDoubleBlock(BlockBehaviour.Properties properties, DoubleBlockDirection extensionDirection) {
        super(properties);
        this.extensionDirection = extensionDirection;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)DoubleBlockPart.BASE)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockPos secondPos = this.getExtensionPosition(context.getClickedPos(), facing);
        if (!context.getLevel().getBlockState(secondPos).canBeReplaced(context)) {
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(PART, (Comparable)((Object)DoubleBlockPart.BASE));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            BlockPos secondPos = this.getExtensionPosition(pos, facing);
            world.setBlock(secondPos, (BlockState)state.setValue(PART, (Comparable)((Object)DoubleBlockPart.EXTENSION)), 3);
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide) {
            DoubleBlockPart part = (DoubleBlockPart)((Object)state.getValue(PART));
            Direction facing = (Direction)state.getValue((Property)FACING);
            Direction right = facing.getClockWise();
            BlockPos otherPos = pos;
            otherPos = switch (this.extensionDirection) {
                default -> throw new MatchException(null, null);
                case DoubleBlockDirection.FRONT -> {
                    if (part == DoubleBlockPart.EXTENSION) {
                        yield pos.relative(facing.getOpposite());
                    }
                    yield pos.relative(facing);
                }
                case DoubleBlockDirection.BACK -> {
                    if (part == DoubleBlockPart.EXTENSION) {
                        yield pos.relative(facing);
                    }
                    yield pos.relative(facing.getOpposite());
                }
                case DoubleBlockDirection.LEFT -> {
                    if (part == DoubleBlockPart.EXTENSION) {
                        yield pos.relative(facing.getClockWise());
                    }
                    yield pos.relative(facing.getCounterClockWise());
                }
                case DoubleBlockDirection.RIGHT -> {
                    if (part == DoubleBlockPart.EXTENSION) {
                        yield pos.relative(facing.getCounterClockWise());
                    }
                    yield pos.relative(facing.getClockWise());
                }
                case DoubleBlockDirection.UP -> {
                    if (part == DoubleBlockPart.EXTENSION) {
                        yield pos.below();
                    }
                    yield pos.above();
                }
                case DoubleBlockDirection.DOWN -> part == DoubleBlockPart.EXTENSION ? pos.above() : pos.below();
            };
            BlockState otherState = world.getBlockState(otherPos);
            if (otherState.getBlock() == this && otherState.getValue(PART) != part) {
                world.destroyBlock(otherPos, false);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Nullable
    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    public BlockPos getExtensionPosition(BlockPos basePos, Direction facing) {
        return switch (this.extensionDirection) {
            default -> throw new MatchException(null, null);
            case DoubleBlockDirection.FRONT -> basePos.relative(facing);
            case DoubleBlockDirection.BACK -> basePos.relative(facing.getOpposite());
            case DoubleBlockDirection.LEFT -> basePos.relative(facing.getCounterClockWise());
            case DoubleBlockDirection.RIGHT -> basePos.relative(facing.getClockWise());
            case DoubleBlockDirection.UP -> basePos.above();
            case DoubleBlockDirection.DOWN -> basePos.below();
        };
    }
}

