/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.ability;

import com.furiusmax.bjornlib.ability.Ability;
import com.furiusmax.bjornlib.capability.IPlayerAbilities;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class AbilityType {
    private final ResourceLocation id;
    private final float cost;
    private final int maxLevel;
    private final AbilityType parent;
    private final AbilityCastType castType;
    private String description;
    public static final AbilityType EMPTY = new AbilityType(ResourceLocation.fromNamespaceAndPath((String)"bjornlib", (String)"empty"), 0, 0.0f, AbilityCastType.PASSIVE, null);

    public AbilityType(ResourceLocation id, int maxLevel, float cost, AbilityCastType castType, AbilityType parent) {
        this.id = id;
        this.maxLevel = maxLevel;
        this.cost = cost;
        this.castType = castType;
        this.parent = parent;
        this.description = id.getPath() + ".description";
    }

    public AbilityType(ResourceLocation id, int maxLevel, float cost, AbilityCastType castType) {
        this.id = id;
        this.maxLevel = maxLevel;
        this.cost = cost;
        this.castType = castType;
        this.parent = null;
        this.description = id.getPath() + ".description";
    }

    public Component getName() {
        return Component.translatable((String)("ability." + this.id.getNamespace() + "." + this.id.getPath()));
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public float getCost() {
        return this.cost;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public AbilityCastType getCastType() {
        return this.castType;
    }

    public Component getDescription(int lvl) {
        return this.getComponentPerLevel(lvl);
    }

    private Component getComponentPerLevel(int i) {
        int level = i == 0 ? 1 : i;
        return Component.translatable((String)(this.description + ".lvl_" + level));
    }

    public boolean onLevelUp(IPlayerAbilities playerAbilities, Ability skill) {
        if (playerAbilities == null) {
            return false;
        }
        Optional parent = playerAbilities.getAbility(skill.type.parent);
        if (parent.isPresent() && ((Ability)parent.get()).level > 0 && skill.getLevel() < skill.getMaxLevel()) {
            return true;
        }
        return !parent.isPresent() && skill.getLevel() < skill.getMaxLevel();
    }

    public Ability createAbility(Player player, int maxLvl) {
        return new Ability(this, player, maxLvl);
    }

    public AbilityType getParent() {
        return this.parent;
    }

    public static enum AbilityCastType {
        PASSIVE("passive"),
        SELF("self"),
        VIEWING("viewing"),
        BLOCK_TARGET("block_target"),
        ENTITY_TARGET("entity_target");

        public String name;

        private AbilityCastType(String name) {
            this.name = name;
        }
    }
}

