/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.networking;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.realmsclient.RealmsMainScreen;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.FCC;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImplClient;
import me.fzzyhmstrs.fzzy_config.impl.ValidScopesArgumentType;
import me.fzzyhmstrs.fzzy_config.impl.ValidSubScopesArgumentType;
import me.fzzyhmstrs.fzzy_config.networking.ConfigPermissionsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateC2SCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.DynamicIdsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.SettingForwardCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.api.ClientPlayNetworkContext;
import me.fzzyhmstrs.fzzy_config.registry.ClientConfigRegistry;
import me.fzzyhmstrs.fzzy_config.screen.PopupController;
import me.fzzyhmstrs.fzzy_config.screen.context.ContextType;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.PortingUtils;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ-\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J7\u0010\u0018\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010 \u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b \u0010\u001fJ\u001d\u0010#\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010%\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010(\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010+\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b+\u0010,J\u001d\u0010.\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b.\u0010/J\u0017\u00102\u001a\u00020\u000f2\u0006\u00101\u001a\u000200H\u0002\u00a2\u0006\u0004\b2\u00103J\u0017\u00105\u001a\u00020\u000f2\u0006\u00101\u001a\u000204H\u0002\u00a2\u0006\u0004\b5\u00106J\r\u00107\u001a\u00020\u000f\u00a2\u0006\u0004\b7\u0010\u0003J\u0017\u00109\u001a\u00020\u000f2\u0006\u00101\u001a\u000208H\u0002\u00a2\u0006\u0004\b9\u0010:J\u001d\u0010>\u001a\u00020\u000f2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020<0;H\u0002\u00a2\u0006\u0004\b>\u0010?R\u0016\u0010@\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010A\u00a8\u0006B"}, d2={"Lme/fzzyhmstrs/fzzy_config/networking/NetworkEventsClient;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "id", "", "canSend", "(Lnet/minecraft/resources/ResourceLocation;)Z", "", "update", "Ljava/util/UUID;", "player", "scope", "summary", "", "forwardSetting", "(Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V", "", "serializedConfigs", "", "changeHistory", "", "playerPerm", "updateServer", "(Ljava/util/Map;Ljava/util/List;I)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigSyncS2CCustomPayload;", "payload", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "context", "handleConfigurationConfigSync", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigSyncS2CCustomPayload;Lnet/neoforged/neoforge/network/handling/IPayloadContext;)V", "handleReloadConfigSync", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigPermissionsS2CCustomPayload;", "Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;", "handleFcPermsUpdate", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigPermissionsS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "handlePermsUpdate", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigPermissionsS2CCustomPayload;Lnet/neoforged/neoforge/network/handling/IPayloadContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateS2CCustomPayload;", "handleUpdate", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateS2CCustomPayload;Lnet/neoforged/neoforge/network/handling/IPayloadContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;", "handleSettingForward", "(Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;Lnet/neoforged/neoforge/network/handling/IPayloadContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/DynamicIdsS2CCustomPayload;", "receiveDynamicIds", "(Lme/fzzyhmstrs/fzzy_config/networking/DynamicIdsS2CCustomPayload;Lnet/neoforged/neoforge/network/handling/IPayloadContext;)V", "Lnet/neoforged/neoforge/client/event/ClientTickEvent$Post;", "event", "handleTick", "(Lnet/neoforged/neoforge/client/event/ClientTickEvent$Post;)V", "Lnet/neoforged/neoforge/client/event/ScreenEvent$Init$Pre;", "registerConfigs", "(Lnet/neoforged/neoforge/client/event/ScreenEvent$Init$Pre;)V", "registerClient", "Lnet/neoforged/neoforge/client/event/RegisterClientCommandsEvent;", "registerCommands", "(Lnet/neoforged/neoforge/client/event/RegisterClientCommandsEvent;)V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "registerClientCommands", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "initialized", "Z", "fzzy_config"})
@SourceDebugExtension(value={"SMAP\nNetworkEventsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkEventsClient.kt\nme/fzzyhmstrs/fzzy_config/networking/NetworkEventsClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public final class NetworkEventsClient {
    @NotNull
    public static final NetworkEventsClient INSTANCE = new NetworkEventsClient();
    private static boolean initialized;

    private NetworkEventsClient() {
    }

    public final boolean canSend(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        if (clientPacketListener == null) {
            return false;
        }
        ClientPacketListener handler = clientPacketListener;
        return NetworkRegistry.hasChannel((ICommonPacketListener)((ICommonPacketListener)handler), (ResourceLocation)id);
    }

    public final void forwardSetting(@NotNull String update, @NotNull UUID player, @NotNull String scope, @NotNull String summary) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        ResourceLocation resourceLocation = SettingForwardCustomPayload.Companion.getType().id();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        if (!this.canSend(resourceLocation)) {
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            if (localPlayer != null) {
                PortingUtils.INSTANCE.sendChat((Player)localPlayer, (Component)FcText.INSTANCE.translate("fc.config.forwarded_error.c2s", new Object[0]));
            }
            FC.INSTANCE.getLOGGER$fzzy_config().error("Can't forward setting; not connected to a server or server isn't accepting this type of data");
            FC.INSTANCE.getLOGGER$fzzy_config().error("Setting not sent:");
            FC.INSTANCE.getLOGGER$fzzy_config().warn(scope);
            FC.INSTANCE.getLOGGER$fzzy_config().warn(summary);
            return;
        }
        ConfigApi.INSTANCE.network().send(new SettingForwardCustomPayload(update, player, scope, summary), null);
    }

    public final void updateServer(@NotNull Map<String, String> serializedConfigs, @NotNull List<String> changeHistory, int playerPerm) {
        Intrinsics.checkNotNullParameter(serializedConfigs, (String)"serializedConfigs");
        Intrinsics.checkNotNullParameter(changeHistory, (String)"changeHistory");
        ResourceLocation resourceLocation = ConfigUpdateC2SCustomPayload.Companion.getType().id();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        if (!this.canSend(resourceLocation)) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Can't send Config Update; not connected to a server or server isn't accepting this type of data");
            FC.INSTANCE.getLOGGER$fzzy_config().error("changes not sent:");
            for (String change : changeHistory) {
                FC.INSTANCE.getLOGGER$fzzy_config().warn(change);
            }
            return;
        }
        ConfigApi.INSTANCE.network().send(new ConfigUpdateC2SCustomPayload(serializedConfigs, changeHistory, playerPerm), null);
    }

    public final void handleConfigurationConfigSync(@NotNull ConfigSyncS2CCustomPayload payload, @NotNull IPayloadContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.receiveSync$fzzy_config(payload.getId(), payload.getSerializedConfig(), arg_0 -> NetworkEventsClient.handleConfigurationConfigSync$lambda$0(context, arg_0));
    }

    public final void handleReloadConfigSync(@NotNull ConfigSyncS2CCustomPayload payload, @NotNull IPayloadContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = payload.getId();
        String string2 = payload.getSerializedConfig();
        Player player = context.player();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player(...)");
        ClientConfigRegistry.INSTANCE.receiveReloadSync$fzzy_config(string, string2, player);
    }

    public final void handleFcPermsUpdate(@NotNull ConfigPermissionsS2CCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.receivePerms$fzzy_config(payload.getId(), payload.getPermissions());
    }

    public final void handlePermsUpdate(@NotNull ConfigPermissionsS2CCustomPayload payload, @NotNull IPayloadContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.receivePerms$fzzy_config(payload.getId(), payload.getPermissions());
    }

    public final void handleUpdate(@NotNull ConfigUpdateS2CCustomPayload payload, @NotNull IPayloadContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map<String, String> map = payload.getUpdates();
        Player player = context.player();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player(...)");
        ClientConfigRegistry.INSTANCE.receiveUpdate$fzzy_config(map, player);
    }

    public final void handleSettingForward(@NotNull SettingForwardCustomPayload payload, @NotNull IPayloadContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.handleForwardedUpdate$fzzy_config(payload.getUpdate(), payload.getPlayer(), payload.getScope(), payload.getSummary());
    }

    public final void receiveDynamicIds(@NotNull DynamicIdsS2CCustomPayload payload, @NotNull IPayloadContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ValidatedIdentifier.Companion.receiveSync$fzzy_config(payload);
    }

    private final void handleTick(ClientTickEvent.Post event) {
        FCC.INSTANCE.withScope(NetworkEventsClient::handleTick$lambda$1);
        FCC.INSTANCE.withRestart(NetworkEventsClient::handleTick$lambda$2);
        PopupController.Companion.popAll$fzzy_config();
    }

    private final void registerConfigs(ScreenEvent.Init.Pre event) {
        if (initialized || !(event.getScreen() instanceof TitleScreen)) {
            return;
        }
        ClientConfigRegistry.INSTANCE.start$fzzy_config();
        Set<String> scopes = ClientConfigRegistry.INSTANCE.getScreenScopes$fzzy_config();
        ModList.get().forEachModInOrder(arg_0 -> NetworkEventsClient.registerConfigs$lambda$5(scopes, arg_0));
        initialized = true;
    }

    public final void registerClient() {
        ContextType.Companion.init$fzzy_config();
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::registerConfigs);
        NeoForge.EVENT_BUS.addListener(this::handleTick);
    }

    private final void registerCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher commandDispatcher = event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"getDispatcher(...)");
        this.registerClientCommands((CommandDispatcher<CommandSourceStack>)commandDispatcher);
    }

    private final void registerClientCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"configure").then(((RequiredArgumentBuilder)Commands.argument((String)"base_scope", (ArgumentType)new ValidScopesArgumentType()).executes(NetworkEventsClient::registerClientCommands$lambda$6)).then(Commands.argument((String)"sub_scope", (ArgumentType)new ValidSubScopesArgumentType()).executes(NetworkEventsClient::registerClientCommands$lambda$8))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"fzzy_config_restart").executes(NetworkEventsClient::registerClientCommands$lambda$9));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"fzzy_config_leave_game").executes(NetworkEventsClient::registerClientCommands$lambda$10));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"fzzy_config_reload_resources").executes(NetworkEventsClient::registerClientCommands$lambda$11));
    }

    private static final void handleConfigurationConfigSync$lambda$0(IPayloadContext $context, Component text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $context.disconnect(text);
    }

    private static final void handleTick$lambda$1(String scopeToOpen) {
        Intrinsics.checkNotNullParameter((Object)scopeToOpen, (String)"scopeToOpen");
        if (!Intrinsics.areEqual((Object)scopeToOpen, (Object)"")) {
            ClientConfigRegistry.INSTANCE.openScreen$fzzy_config(scopeToOpen);
        }
    }

    private static final Boolean handleTick$lambda$2(Boolean openRestartScreen) {
        Intrinsics.checkNotNullParameter((Object)openRestartScreen, (String)"openRestartScreen");
        return openRestartScreen != false ? Boolean.valueOf(ConfigApiImplClient.INSTANCE.openRestartScreen$fzzy_config()) : Boolean.valueOf(false);
    }

    private static final Screen registerConfigs$lambda$5$lambda$4$lambda$3(String $id, ModContainer modContainer, Screen screen) {
        Intrinsics.checkNotNull((Object)$id);
        Screen screen2 = ClientConfigRegistry.INSTANCE.provideScreen$fzzy_config($id);
        if (screen2 == null) {
            screen2 = screen;
        }
        return screen2;
    }

    private static final IConfigScreenFactory registerConfigs$lambda$5$lambda$4(String $id) {
        return (arg_0, arg_1) -> NetworkEventsClient.registerConfigs$lambda$5$lambda$4$lambda$3($id, arg_0, arg_1);
    }

    private static final void registerConfigs$lambda$5(Set $scopes, ModContainer modContainer) {
        String id = modContainer.getModId();
        if ($scopes.contains(id) && modContainer.getCustomExtension(IConfigScreenFactory.class).isEmpty()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, () -> NetworkEventsClient.registerConfigs$lambda$5$lambda$4(id));
        }
    }

    private static final int registerClientCommands$lambda$6(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        String scope = ValidScopesArgumentType.Companion.getValidScope(context, "base_scope");
        String string = scope;
        if (string == null) {
            string = "";
        }
        FCC.INSTANCE.openScopedScreen(string);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final int registerClientCommands$lambda$8(CommandContext context) {
        Object object;
        FCC fCC;
        block7: {
            block4: {
                String string;
                Object object2;
                block6: {
                    block5: {
                        void it;
                        Intrinsics.checkNotNull((Object)context);
                        String scope = ValidScopesArgumentType.Companion.getValidScope(context, "base_scope");
                        String subScope = ValidSubScopesArgumentType.Companion.getValidSubScope(context, "sub_scope");
                        fCC = FCC.INSTANCE;
                        object = scope;
                        if (object == null) break block4;
                        object2 = subScope;
                        if (object2 == null) break block5;
                        String string2 = object2;
                        String string3 = object;
                        FCC fCC2 = fCC;
                        boolean bl = false;
                        String string4 = "." + (String)it;
                        fCC = fCC2;
                        string = string3;
                        String string5 = string4;
                        object2 = string5;
                        if (string5 != null) break block6;
                    }
                    object2 = "";
                }
                if ((object = string + (String)object2) != null) break block7;
            }
            object = "";
        }
        fCC.openScopedScreen((String)object);
        return 1;
    }

    private static final int registerClientCommands$lambda$9(CommandContext context) {
        Minecraft.getInstance().stop();
        return 1;
    }

    private static final int registerClientCommands$lambda$10(CommandContext context) {
        Minecraft c = Minecraft.getInstance();
        boolean sp = c.isLocalServer();
        ServerData serverInfo = c.getCurrentServer();
        ClientLevel clientLevel = c.level;
        if (clientLevel != null) {
            clientLevel.disconnect();
        }
        c.disconnect();
        TitleScreen titleScreen = new TitleScreen();
        if (sp) {
            c.setScreen((Screen)titleScreen);
        } else if (serverInfo != null && serverInfo.isRealm()) {
            c.setScreen((Screen)new RealmsMainScreen((Screen)titleScreen));
        } else {
            c.setScreen((Screen)new JoinMultiplayerScreen((Screen)titleScreen));
        }
        return 1;
    }

    private static final int registerClientCommands$lambda$11(CommandContext context) {
        Minecraft.getInstance().reloadResourcePacks();
        return 1;
    }
}

